/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.netty.impl.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import java.io.IOException;
import java.io.InputStream;
import org.mule.runtime.http.api.domain.entity.HttpEntity;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;

public class ChunkedHttpEntityPublisher
extends Flux<ByteBuf> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ChunkedHttpEntityPublisher.class);
    private final HttpEntity httpEntity;
    private final int bufferSize;

    public ChunkedHttpEntityPublisher(HttpEntity httpEntity) {
        this(httpEntity, 8192);
    }

    public ChunkedHttpEntityPublisher(HttpEntity httpEntity, int bufferSize) {
        this.httpEntity = httpEntity;
        this.bufferSize = bufferSize;
    }

    public void subscribe(CoreSubscriber<? super ByteBuf> actual) {
        actual.onSubscribe((Subscription)new InputStreamSubscription(actual, this.httpEntity, this.bufferSize));
    }

    private static class InputStreamSubscription
    implements Subscription {
        private static final String HTTP_ENTITY_PRECONDITION = "If a HttpEntity returns true for isStreaming(), it has to provide a length in getBytesLength()";
        private final CoreSubscriber<? super ByteBuf> subscriber;
        private final HttpEntity httpEntity;
        private final int bufferSize;
        private final InputStream contentAsInputStream;

        InputStreamSubscription(CoreSubscriber<? super ByteBuf> subscriber, HttpEntity entity, int bufferSize) {
            this.subscriber = subscriber;
            this.httpEntity = entity;
            this.bufferSize = InputStreamSubscription.getBufferSize(entity, bufferSize);
            this.contentAsInputStream = this.httpEntity.isStreaming() ? entity.getContent() : null;
        }

        private static int getBufferSize(HttpEntity entity, int bufferSize) {
            if (entity.isStreaming()) {
                return Math.min(Math.toIntExact(entity.getBytesLength().orElse(bufferSize)), bufferSize);
            }
            return (int)entity.getBytesLength().orElseThrow(() -> new IllegalStateException(HTTP_ENTITY_PRECONDITION));
        }

        public void request(long requestedChunks) {
            try {
                if (this.httpEntity.isStreaming()) {
                    this.sendRequestedChunksAndCompleteIfFullyConsumed(requestedChunks);
                } else {
                    this.sendAllContentInOneNextAndComplete();
                }
            }
            catch (IOException e) {
                this.subscriber.onError((Throwable)e);
            }
        }

        private void sendRequestedChunksAndCompleteIfFullyConsumed(long requestedChunks) throws IOException {
            boolean contentIsFullyConsumed = false;
            int sentChunks = 0;
            while (!contentIsFullyConsumed && (long)sentChunks < requestedChunks) {
                byte[] buffer = new byte[this.bufferSize];
                int bytesActuallyRead = this.contentAsInputStream.read(buffer);
                contentIsFullyConsumed = bytesActuallyRead <= 0;
                if (contentIsFullyConsumed) continue;
                ByteBuf byteBuf = InputStreamSubscription.createByteBuf(buffer, bytesActuallyRead);
                this.subscriber.onNext((Object)byteBuf);
                ++sentChunks;
            }
            if (contentIsFullyConsumed) {
                this.subscriber.onComplete();
            }
        }

        private void sendAllContentInOneNextAndComplete() throws IOException {
            byte[] bytesRead = this.httpEntity.getBytes();
            if (bytesRead.length > 0) {
                ByteBuf byteBuf = InputStreamSubscription.createByteBuf(bytesRead, bytesRead.length);
                this.subscriber.onNext((Object)byteBuf);
            }
            this.subscriber.onComplete();
        }

        private static ByteBuf createByteBuf(byte[] bytesRead, int bufferSize) {
            return ByteBufAllocator.DEFAULT.buffer(bufferSize, bufferSize).writeBytes(bytesRead, 0, bufferSize);
        }

        public void cancel() {
            try {
                if (this.contentAsInputStream != null) {
                    this.contentAsInputStream.close();
                }
            }
            catch (IOException e) {
                LOGGER.warn("There was a problem while closing the request content stream", (Throwable)e);
            }
        }
    }
}

