/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.deployment;

import com.mulesoft.agent.domain.deployment.Application;
import com.mulesoft.agent.domain.deployment.DeploymentStatus;
import com.mulesoft.agent.domain.deployment.Domain;
import com.mulesoft.agent.domain.deployment.DomainMuleDeploymentNotification;
import com.mulesoft.agent.exception.ConcurrentDeploymentException;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.ApplicationService;
import com.mulesoft.agent.services.ConfigurableAgentService;
import com.mulesoft.agent.services.DomainService;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.config.custom.CustomizationService;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.module.deployment.api.DeploymentListener;
import org.mule.runtime.module.deployment.api.DeploymentService;
import org.mule.runtime.module.deployment.api.DeploymentServiceAware;
import org.mule.runtime.module.reboot.api.MuleContainerBootstrapUtils;

@Named(value="mule.agent.domain.service")
@Singleton
public class AgentDomainService
extends ConfigurableAgentService
implements DomainService,
DeploymentServiceAware {
    private static final Logger LOGGER = LogManager.getLogger(AgentDomainService.class);
    private DeploymentService deploymentService;
    private AgentDomainDeploymentListener deploymentDomainListener = new AgentDomainDeploymentListener();
    private ExecutorService redeploymentThreadPool = Executors.newFixedThreadPool(5);
    @Inject
    List<InternalMessageHandler<DomainMuleDeploymentNotification>> domainDeploymenHandlers;
    @Inject
    List<InternalMessageHandler<List<Domain>>> domainListHandlers;
    @Inject
    private ApplicationService applicationService;
    private static final String ARTIFACT_EXTENSION = ".jar";

    public void setDeploymentService(DeploymentService deploymentService) {
        this.deploymentService = deploymentService;
    }

    public void doStart() throws MuleException {
        this.deploymentService.addDomainDeploymentListener((DeploymentListener)this.deploymentDomainListener);
    }

    public void doStop() throws MuleException {
        this.deploymentService.removeDomainDeploymentListener((DeploymentListener)this.deploymentDomainListener);
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        ArrayList<InternalMessageHandler> handlerList = new ArrayList<InternalMessageHandler>(this.domainDeploymenHandlers);
        handlerList.addAll(this.domainListHandlers);
        return handlerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(String domainName, String url) throws ConcurrentDeploymentException {
        LOGGER.info("Deploying the {} domain from URL {}", (Object)domainName, (Object)url);
        ReentrantLock lock = this.deploymentService.getLock();
        try {
            this.lockDeploymentService(lock);
            URL fileUrl = new URL(url);
            File file = new File(System.getProperty("java.io.tmpdir"), domainName + ARTIFACT_EXTENSION);
            BufferedOutputStream outStream = new BufferedOutputStream(FileUtils.openOutputStream((File)file));
            try {
                IOUtils.copyLarge((InputStream)fileUrl.openStream(), (OutputStream)outStream);
            }
            finally {
                IOUtils.closeQuietly((OutputStream)outStream);
            }
            this.deploymentService.deployDomain(file.toURI());
        }
        catch (MalformedURLException e) {
            LOGGER.error("The URL {} for the domain {} is malformed. Error: {}", (Object)url, (Object)domainName, (Object)e.getMessage());
            this.sendDomainDeploymentNotification(new DomainMuleDeploymentNotification(new Domain(domainName), DeploymentStatus.UNDEPLOYED, "The URL is incorrect"));
        }
        catch (IOException e) {
            LOGGER.error("There the domain {} doesn't exist at {}. Error: {}", (Object)domainName, (Object)url, (Object)e.getMessage());
            this.sendDomainDeploymentNotification(new DomainMuleDeploymentNotification(new Domain(domainName), DeploymentStatus.UNDEPLOYED, "The File does not exist"));
        }
        catch (MuleRuntimeException e) {
            LOGGER.error("There was an error on the Mule Runtime while deploying the application {}. Error: {}", (Object)domainName, (Object)e.getMessage());
        }
        finally {
            this.unlockDeploymentService(lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deploy(String domainName, byte[] domain) throws ConcurrentDeploymentException {
        LOGGER.info("Deploying the {} domain from jar file.", (Object)domainName);
        ReentrantLock lock = this.deploymentService.getLock();
        URI tempDirPath = null;
        try {
            this.lockDeploymentService(lock);
            tempDirPath = this.createTempDir();
            File file = new File(new File(tempDirPath), domainName + ARTIFACT_EXTENSION);
            try (FileOutputStream stream = new FileOutputStream(file);){
                stream.write(domain);
            }
            this.deploymentService.deployDomain(file.toURI());
        }
        catch (IOException e) {
            LOGGER.error("The file for the domain {} is corrupt. Error: {}", (Object)domainName, (Object)e.getMessage());
            this.sendDomainDeploymentNotification(new DomainMuleDeploymentNotification(new Domain(domainName), DeploymentStatus.UNDEPLOYED, "The File is corrupt"));
        }
        catch (MuleRuntimeException e) {
            LOGGER.error("There was an error on the Mule Runtime while deploying the domain {}. Error: {}", (Object)domainName, (Object)e.getMessage());
        }
        finally {
            this.unlockDeploymentService(lock);
            this.removeTempDir(tempDirPath);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void undeploy(String domainName) throws ConcurrentDeploymentException {
        block4: {
            LOGGER.info("Undeploying the {} domain.", (Object)domainName);
            ReentrantLock lock = this.deploymentService.getLock();
            try {
                this.lockDeploymentService(lock);
                org.mule.runtime.deployment.model.api.domain.Domain domain = this.deploymentService.findDomain(domainName);
                if (domain != null) {
                    this.deploymentService.undeployDomain(domainName);
                    break block4;
                }
                this.sendDomainDeploymentNotification(new DomainMuleDeploymentNotification(new Domain(domainName), DeploymentStatus.UNDEPLOYED, "Nothing to undeploy"));
                throw new IllegalArgumentException("Domain does not exist:" + domainName);
            }
            finally {
                this.unlockDeploymentService(lock);
            }
        }
    }

    public void redeploy(String domainName) throws ConcurrentDeploymentException, IllegalArgumentException {
        block4: {
            LOGGER.info("Redeploying the {} domain.", (Object)domainName);
            ReentrantLock lock = this.deploymentService.getLock();
            try {
                this.lockDeploymentService(lock);
                if (this.deploymentService.findDomain(domainName) != null) {
                    this.deploymentService.redeployDomain(domainName);
                    break block4;
                }
                this.sendDomainDeploymentNotification(new DomainMuleDeploymentNotification(new Domain(domainName), DeploymentStatus.UNDEPLOYED, "Nothing to redeploy"));
                throw new IllegalArgumentException("Domain does not exist:" + domainName);
            }
            finally {
                this.unlockDeploymentService(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redeploy(String domainName, String url) throws ConcurrentDeploymentException {
        block12: {
            LOGGER.info("Redeploying the {} domain from URL {}", (Object)domainName, (Object)url);
            ReentrantLock lock = this.deploymentService.getLock();
            DeploymentListener redeploymentListener = null;
            try {
                this.lockDeploymentService(lock);
                if (this.deploymentService.findDomain(domainName) != null) {
                    URL fileUrl = new URL(url);
                    File file = new File(MuleContainerBootstrapUtils.getMuleDomainsDir(), domainName + ARTIFACT_EXTENSION);
                    BufferedOutputStream outStream = new BufferedOutputStream(FileUtils.openOutputStream((File)file));
                    try {
                        IOUtils.copyLarge((InputStream)fileUrl.openStream(), (OutputStream)outStream);
                        break block12;
                    }
                    finally {
                        IOUtils.closeQuietly((OutputStream)outStream);
                    }
                }
                this.sendDomainDeploymentNotification(new DomainMuleDeploymentNotification(new Domain(domainName), DeploymentStatus.UNDEPLOYED, "Nothing to undeploy"));
                throw new IllegalArgumentException("Domain does not exist:" + domainName);
            }
            catch (IOException e) {
                LOGGER.error("The domain {} doesn't exist at {}. Error: {}", (Object)domainName, (Object)url, (Object)e.getMessage());
                this.sendDomainDeploymentNotification(new DomainMuleDeploymentNotification(new Domain(domainName), DeploymentStatus.UNDEPLOYED, "The File does not exist"));
            }
            catch (Exception e) {
                if (redeploymentListener != null) {
                    this.deploymentService.removeDomainDeploymentListener(redeploymentListener);
                }
                throw e;
            }
            finally {
                this.unlockDeploymentService(lock);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void redeploy(String domainName, byte[] domain) throws ConcurrentDeploymentException {
        block12: {
            LOGGER.info("Redeploying the {} domain from jar file.", (Object)domainName);
            ReentrantLock lock = this.deploymentService.getLock();
            DeploymentListener redeploymentListener = null;
            try {
                this.lockDeploymentService(lock);
                if (this.deploymentService.findDomain(domainName) != null) {
                    File file = new File(MuleContainerBootstrapUtils.getMuleDomainsDir(), domainName + ARTIFACT_EXTENSION);
                    try (FileOutputStream stream = new FileOutputStream(file);){
                        stream.write(domain);
                        break block12;
                    }
                }
                this.sendDomainDeploymentNotification(new DomainMuleDeploymentNotification(new Domain(domainName), DeploymentStatus.UNDEPLOYED, "Nothing to undeploy"));
                throw new IllegalArgumentException("Domain does not exist:" + domainName);
            }
            catch (IOException e) {
                LOGGER.error("The file for the domain {} is corrupt. Error: {}", (Object)domainName, (Object)e.getMessage());
                this.sendDomainDeploymentNotification(new DomainMuleDeploymentNotification(new Domain(domainName), DeploymentStatus.UNDEPLOYED, "The File does not exist"));
            }
            catch (Exception e) {
                if (redeploymentListener != null) {
                    this.deploymentService.removeDomainDeploymentListener(redeploymentListener);
                }
                throw e;
            }
            finally {
                this.unlockDeploymentService(lock);
            }
        }
    }

    public List<Domain> listDomains() {
        List<Domain> domains = this.convertDomains(this.deploymentService.getDomains());
        for (Domain domain : domains) {
            domain.setApplications(this.convertApplications(this.deploymentService.findDomainApplications(domain.getName())));
        }
        this.sendDomainListNotification(domains);
        return domains;
    }

    public Domain getDomain(String domainName) {
        org.mule.runtime.deployment.model.api.domain.Domain muleDomain = this.deploymentService.findDomain(domainName);
        if (muleDomain != null) {
            Domain domain = new Domain(domainName);
            List<Application> applications = this.convertApplications(this.deploymentService.findDomainApplications(domainName));
            domain.setApplications(applications);
            return domain;
        }
        return null;
    }

    private List<Application> convertApplications(Collection<org.mule.runtime.deployment.model.api.application.Application> muleApplications) {
        LinkedList<Application> applications = new LinkedList<Application>();
        for (org.mule.runtime.deployment.model.api.application.Application muleApplication : muleApplications) {
            applications.add(this.applicationService.getApplication(muleApplication.getArtifactName()));
        }
        return applications;
    }

    private List<Domain> convertDomains(Collection<org.mule.runtime.deployment.model.api.domain.Domain> muleDomains) {
        LinkedList<Domain> domains = new LinkedList<Domain>();
        for (org.mule.runtime.deployment.model.api.domain.Domain muleDomain : muleDomains) {
            domains.add(new Domain(muleDomain.getArtifactName()));
        }
        return domains;
    }

    private void sendDomainDeploymentNotification(DomainMuleDeploymentNotification message) {
        for (InternalMessageHandler<DomainMuleDeploymentNotification> handler : this.domainDeploymenHandlers) {
            handler.handle((Object)message);
        }
    }

    private void sendDomainListNotification(List<Domain> message) {
        for (InternalMessageHandler<List<Domain>> handler : this.domainListHandlers) {
            handler.handle(message);
        }
    }

    private URI createTempDir() throws IOException {
        try {
            URI uri = Files.createTempDirectory("mule-received-artifact-", new FileAttribute[0]).toUri();
            File dir = new File(uri);
            dir.setReadable(true, false);
            dir.setWritable(true, false);
            dir.setExecutable(true, false);
            return uri;
        }
        catch (Exception e) {
            LOGGER.error("Could not create temporary directory for mule artifact deployment.  Exception was: " + e.getMessage());
            throw new IOException();
        }
    }

    private void removeTempDir(URI path) {
        try {
            FileUtils.cleanDirectory((File)new File(path));
            Files.deleteIfExists(Paths.get(path));
        }
        catch (Exception e) {
            LOGGER.error("Could not remove temporary directory used for mule artifact deployment.  Exception was: " + e.getMessage());
        }
    }

    private void lockDeploymentService(ReentrantLock lock) throws ConcurrentDeploymentException {
        try {
            if (!lock.tryLock(250L, TimeUnit.MILLISECONDS)) {
                throw new ConcurrentDeploymentException("There is another deployment operation in progress. Retry later");
            }
        }
        catch (InterruptedException e) {
            throw new ConcurrentDeploymentException("There are multiples deployment requests at the same time, this will be ignored. Retry Later");
        }
    }

    private void unlockDeploymentService(ReentrantLock lock) {
        if (lock.isHeldByCurrentThread()) {
            lock.unlock();
        }
    }

    private class RedeploymentDeploymentListener
    implements DeploymentListener {
        private ReentrantLock lock;
        private String domainName;
        private URI uri;

        public RedeploymentDeploymentListener(ReentrantLock lock, String domainName, URI uri) {
            this.lock = lock;
            this.domainName = domainName;
            this.uri = uri;
        }

        public void onUndeploymentSuccess(String domainName) {
            if (domainName.equals(this.domainName)) {
                try {
                    AgentDomainService.this.deploymentService.deployDomain(this.uri);
                }
                catch (IOException e) {
                    AgentDomainService.this.sendDomainDeploymentNotification(new DomainMuleDeploymentNotification(new Domain(domainName), DeploymentStatus.UNDEPLOYED, "Failure in deployment stage of redeployment"));
                }
                AgentDomainService.this.deploymentService.removeDomainDeploymentListener((DeploymentListener)this);
                AgentDomainService.this.unlockDeploymentService(this.lock);
            }
        }

        public void onUndeploymentFailure(String domainName, Throwable cause) {
            if (domainName.equals(this.domainName)) {
                AgentDomainService.this.unlockDeploymentService(this.lock);
                AgentDomainService.this.deploymentService.removeDomainDeploymentListener((DeploymentListener)this);
            }
        }
    }

    private class AgentDomainDeploymentListener
    implements DeploymentListener {
        private AgentDomainDeploymentListener() {
        }

        public void onDeploymentSuccess(String appName) {
            AgentDomainService.this.sendDomainDeploymentNotification(new DomainMuleDeploymentNotification(new Domain(appName), DeploymentStatus.DEPLOYED, ""));
        }

        public void onDeploymentStart(String appName) {
            AgentDomainService.this.sendDomainDeploymentNotification(new DomainMuleDeploymentNotification(new Domain(appName), DeploymentStatus.DEPLOYMENT_STARTED, ""));
        }

        public void onDeploymentFailure(String appName, Throwable cause) {
            AgentDomainService.this.sendDomainDeploymentNotification(new DomainMuleDeploymentNotification(new Domain(appName), DeploymentStatus.DEPLOYMENT_FAILED, cause.getMessage()));
        }

        public void onArtifactCreated(String appName, CustomizationService customizationService) {
            AgentDomainService.this.sendDomainDeploymentNotification(new DomainMuleDeploymentNotification(new Domain(appName), DeploymentStatus.CONTEXT_CREATED, ""));
        }

        public void onArtifactInitialised(String appName, Registry registry) {
            AgentDomainService.this.sendDomainDeploymentNotification(new DomainMuleDeploymentNotification(new Domain(appName), DeploymentStatus.CONTEXT_INITIALISED, ""));
        }

        public void onUndeploymentStart(String appName) {
            AgentDomainService.this.sendDomainDeploymentNotification(new DomainMuleDeploymentNotification(new Domain(appName), DeploymentStatus.UNDEPLOYING, ""));
        }

        public void onUndeploymentSuccess(String appName) {
            AgentDomainService.this.sendDomainDeploymentNotification(new DomainMuleDeploymentNotification(new Domain(appName), DeploymentStatus.UNDEPLOYED, ""));
        }

        public void onUndeploymentFailure(String appName, Throwable cause) {
            AgentDomainService.this.sendDomainDeploymentNotification(new DomainMuleDeploymentNotification(new Domain(appName), DeploymentStatus.UNDEPLOYMENT_FAILED, "Undeployment failed " + cause.getMessage()));
        }
    }
}

