/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.description;

import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.module.extension.internal.capability.xml.DocumenterUtils;
import org.mule.runtime.module.extension.internal.capability.xml.description.AbstractDescriptionDocumenter;
import org.mule.runtime.module.extension.internal.capability.xml.schema.MethodDocumentation;

final class ParameterDescriptionDocumenter
extends AbstractDescriptionDocumenter {
    ParameterDescriptionDocumenter(ProcessingEnvironment processingEnv) {
        super(processingEnv);
    }

    void document(ParameterizedDeclaration<?> parameterized, Element method, MethodDocumentation documentation) {
        parameterized.getAllParameters().forEach(p -> {
            String description = documentation.getParameters().get(p.getName());
            if (description != null) {
                p.setDescription(description);
            }
        });
        if (method instanceof ExecutableElement) {
            ((ExecutableElement)method).getParameters().stream().filter(DocumenterUtils::isParameterGroup).forEach(group -> {
                TypeElement typeElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(group.asType());
                this.document(parameterized, typeElement);
            });
        }
    }

    void document(ParameterizedDeclaration<?> parameterized, TypeElement element) {
        TypeElement traversingElement = element;
        while (traversingElement != null && !Object.class.getName().equals(traversingElement.getQualifiedName().toString())) {
            Map<String, VariableElement> variableElements = DocumenterUtils.getParameters(element, processor).entrySet().stream().collect(Collectors.toMap(entry -> this.getNameOrAlias((Element)entry.getValue()), Map.Entry::getValue));
            parameterized.getAllParameters().stream().filter(param -> variableElements.containsKey(param.getName())).forEach(param -> {
                String summary = processor.getJavaDocSummary(this.processingEnv, (Element)variableElements.get(param.getName()));
                param.setDescription(summary);
            });
            traversingElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(traversingElement.getSuperclass());
        }
        for (VariableElement variableElement : DocumenterUtils.getParameterGroups(element, processor).values()) {
            TypeElement typeElement = (TypeElement)this.processingEnv.getTypeUtils().asElement(variableElement.asType());
            this.document(parameterized, typeElement);
        }
    }
}

