/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.value.impl;

import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.mule.tooling.utils.UtilsPlugin;
import org.mule.tooling.utils.value.EvaluationDebugger;
import org.mule.tooling.utils.value.impl.SimpleEvaluationDebugger;

public class TracerDebuggerFactory
implements EvaluationDebugger.Factory {
    private final String debugOption;
    private final boolean enabled;
    private final Supplier<DebugTrace> tracer;

    private TracerDebuggerFactory(Supplier<DebugTrace> tracer, String pluginId, String debugOption) {
        this.debugOption = debugOption;
        this.enabled = UtilsPlugin.isDebugEnabled(pluginId, debugOption);
        this.tracer = tracer;
    }

    @Override
    public EvaluationDebugger newDebugger() {
        return SimpleEvaluationDebugger.newDebugger(this::trace);
    }

    private void trace(String output) {
        Optional.ofNullable(this.tracer.get()).ifPresent(debugTrace -> this.trace((DebugTrace)debugTrace, output));
    }

    private void trace(DebugTrace debugTracer, String output) {
        debugTracer.trace(this.debugOption, output);
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    public static EvaluationDebugger.Factory create(Supplier<DebugTrace> tracer, String pluginId, String debugOption) {
        return new TracerDebuggerFactory(tracer, pluginId, debugOption);
    }
}

