/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.value.impl;

import java.util.Arrays;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.utils.value.EvaluationDebugger;
import org.mule.tooling.utils.value.Value;

public class SimpleEvaluationDebugger
implements EvaluationDebugger {
    private final Deque<Frame> frames = new LinkedList<Frame>(Arrays.asList(new Frame("_")));
    private final Consumer<String> tracer;

    private SimpleEvaluationDebugger(Consumer<String> tracer) {
        this.tracer = tracer;
    }

    private void addFrame(Value<?> newFrame) {
        this.frames.add(new Frame(newFrame));
    }

    private void dropFrame() {
        this.frames.removeLast();
    }

    private Frame currentFrame() {
        return this.frames.getLast();
    }

    @Override
    public void addDescription(String annotation) {
        this.currentFrame().addDescription(annotation);
    }

    @Override
    public <V> Optional<V> monitorComputation(Value<V> toEvaluate, Supplier<Optional<V>> computation) {
        this.addFrame(toEvaluate);
        try {
            int stackSize = this.frames.size();
            String prefix = StringUtils.repeat((String)" ", (int)(4 * (stackSize - 1)));
            this.doShow(prefix + this.currentFrame().getDescription() + " [");
            Optional<V> result = computation.get();
            this.doShow(prefix + "    " + this.currentFrame().getDescription() + " = " + result.map(it -> it.getClass().getSimpleName() + ": " + String.valueOf(it)).orElse("<NONE>"));
            this.doShow(prefix + "]");
            Optional<V> optional = result;
            return optional;
        }
        finally {
            this.dropFrame();
        }
    }

    @Override
    public void show(Supplier<Object> ... message) {
        this.doShow(Arrays.stream(message).map(Supplier::get).map(String::valueOf).reduce("", (a, b) -> a + " : " + b));
    }

    private void doShow(String toShow) {
        this.tracer.accept(toShow);
    }

    public static EvaluationDebugger newDebugger(Consumer<String> tracer) {
        return new SimpleEvaluationDebugger(tracer);
    }

    public static EvaluationDebugger newDebugger() {
        return SimpleEvaluationDebugger.newDebugger(System.out::println);
    }

    static class Frame {
        private String description;

        public Frame(Value<?> value) {
            this(value.getDescription());
        }

        public Frame(String description) {
            this.description = description;
        }

        public void addDescription(String annotation) {
            this.description = " [" + annotation + "]";
        }

        public String getDescription() {
            return this.description;
        }
    }
}

