/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.value.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.mule.tooling.utils.value.EvaluationContext;
import org.mule.tooling.utils.value.Value;
import org.mule.tooling.utils.value.caching.CachePolicy;
import org.mule.tooling.utils.value.impl.CachedValue;

public class PolicyBasedCachedValue<T>
extends CachedValue<T> {
    private final List<CachePolicy<T>> policies;

    public PolicyBasedCachedValue(Value<T> source, CachePolicy<T> policy) {
        super(source);
        this.policies = Arrays.asList(policy);
    }

    public PolicyBasedCachedValue(Value<T> source, List<CachePolicy<T>> policies) {
        super(source);
        this.policies = policies;
    }

    @Override
    public boolean isStale(EvaluationContext context, T value) {
        for (CachePolicy<T> current : this.policies) {
            boolean stale = current.isStale(value, context);
            if (!stale) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Optional<T> recompute(EvaluationContext context) {
        Optional recomputed = super.recompute(context);
        if (recomputed.isPresent()) {
            for (CachePolicy current : this.policies) {
                current.updated(recomputed, context);
            }
        }
        return recomputed;
    }
}

