/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.value.impl;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.mule.tooling.utils.value.EvaluationContext;
import org.mule.tooling.utils.value.Value;

public class OutboundInvocationHandler
implements InvocationHandler {
    private final EvaluationContext.OutboundRequests outbound;
    private final MethodExecutionTracker methodExecutionTracker;

    OutboundInvocationHandler(EvaluationContext.OutboundRequests context, MethodExecutionTracker describer) {
        this.outbound = context;
        this.methodExecutionTracker = describer;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = this.executeMethod(method, args);
        this.methodExecutionTracker.track(method, Value.unchecked(() -> this.executeMethod(method, args)), result);
        return result;
    }

    private Object executeMethod(Method method, Object[] args) throws Throwable {
        try {
            return method.invoke((Object)this.outbound, args);
        }
        catch (ReflectiveOperationException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error || cause instanceof RuntimeException || Arrays.asList(method.getExceptionTypes()).contains(e.getClass())) {
                throw cause;
            }
            throw new RuntimeException(e);
        }
    }

    private static Stream<Class<?>> getAllInterfaces(Class<?> start) {
        Stream<Class<?>> mine = Arrays.stream(start.getInterfaces());
        Stream inherited = Optional.ofNullable(start.getSuperclass()).map(OutboundInvocationHandler::getAllInterfaces).orElse(Stream.empty());
        return Stream.concat(mine, inherited);
    }

    public static <O extends EvaluationContext.OutboundRequests> O monitor(O outbound, MethodExecutionTracker describer) {
        Class[] interfaces = (Class[])OutboundInvocationHandler.getAllInterfaces(outbound.getClass()).toArray(Class[]::new);
        ClassLoader classLoader = outbound.getClass().getClassLoader();
        OutboundInvocationHandler newInvoker = new OutboundInvocationHandler(outbound, describer);
        Object proxied = Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)newInvoker);
        return (O)((EvaluationContext.OutboundRequests)proxied);
    }

    @FunctionalInterface
    public static interface MethodExecutionTracker {
        public void track(Method var1, Supplier<Object> var2, Object var3);
    }
}

