/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.value.impl;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.primitives.Primitives;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.tooling.utils.value.EvaluationContext;
import org.mule.tooling.utils.value.EvaluationDebugger;
import org.mule.tooling.utils.value.Value;
import org.mule.tooling.utils.value.ValueException;
import org.mule.tooling.utils.value.impl.DebuggableEvaluationFingerprint;
import org.mule.tooling.utils.value.impl.EvaluationFingerprint;
import org.mule.tooling.utils.value.impl.EvaluationRequest;
import org.mule.tooling.utils.value.impl.HashBasedFingerprint;
import org.mule.tooling.utils.value.impl.OutboundInvocationHandler;

public abstract class InternalEvaluationContextImpl<O extends EvaluationContext.OutboundRequests>
implements EvaluationContext {
    private O outboundRequests;
    private EvaluationDebugger.Factory debuggerSupplier = EvaluationDebugger::noOpDebugger;
    private ThreadLocal<EvaluationDebugger> debugger = new ThreadLocal();
    private ValueComputer computer = this::doCompute;
    private FingerprintProvider fingerprintProvider = this::newHashBasedFingerprint;
    private ThreadLocal<EvaluationRequest> evaluationRequest = new ThreadLocal();
    private Map<Object, Object> valueMetadata = Collections.synchronizedMap(new HashMap());
    private Cache<Value<?>, EvaluationFingerprint> cachedFingerprints = CacheBuilder.newBuilder().initialCapacity(20).maximumSize(200L).build();
    private Cache<Value<?>, Object> cachedValues = CacheBuilder.newBuilder().initialCapacity(20).maximumSize(200L).build();

    protected InternalEvaluationContextImpl(O outboundRequests) {
        this.outboundRequests = OutboundInvocationHandler.monitor(outboundRequests, this::trackRequest);
    }

    @Override
    public <EC extends EvaluationContext> EC debugging(EvaluationDebugger.Factory factory) {
        if (factory.isEnabled()) {
            this.debuggerSupplier = factory;
            this.computer = this::monitorComputation;
            this.fingerprintProvider = this::newDebuggableFingerprint;
        }
        return (EC)this;
    }

    private EvaluationRequest currentRequest() {
        return this.evaluationRequest.get();
    }

    private void trackRequest(Method method, Supplier<Object> valueComputer, Object valueSnapshot) {
        if (this.debugger.get() != null) {
            this.debugger.get().addDescription(method.getName());
        }
        if (this.evaluationRequest.get() != null && this.isBasicValue(valueSnapshot)) {
            this.evaluationRequest.get().trackValue(new EvaluationFingerprint.Atom(method, () -> Optional.ofNullable(valueComputer.get()), Optional.ofNullable(valueSnapshot)));
        }
    }

    private boolean isBasicValue(Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Collection) {
            Collection asCollection = (Collection)value;
            return asCollection.isEmpty() ? true : this.isBasicValue(asCollection.iterator().next());
        }
        return value instanceof CharSequence || Primitives.allWrapperTypes().contains(value.getClass());
    }

    @Override
    public boolean ignoreCachedValues() {
        return this.currentRequest().ignoreCachedValues();
    }

    @Override
    public <R> Optional<R> evaluateUpstream(Value<R> toEvaluate) {
        this.ensureUnderEvaluation();
        return this.performComputation(toEvaluate);
    }

    private void ensureUnderEvaluation() {
        if (this.evaluationRequest.get() == null) {
            throw new IllegalStateException("may only be invoked during evaluation");
        }
    }

    private <R> Optional<R> performComputation(Value<R> toEvaluate) {
        try {
            Optional<R> result = this.computer.compute(toEvaluate);
            this.updateFingerprint(toEvaluate, result);
            return result;
        }
        catch (RuntimeException e) {
            if (e instanceof ValueException) {
                throw e;
            }
            throw new ValueException(e);
        }
    }

    private <R> void updateFingerprint(Value<R> beingComputed, Optional<R> result) {
        if (beingComputed.isTrivial()) {
            this.currentRequest().trackValue(new EvaluationFingerprint.Atom(beingComputed, () -> beingComputed.compute(this), result));
        }
    }

    @Override
    public <R> Optional<R> evaluate(Value<R> toEvaluate) {
        this.debugger.set(this.debuggerSupplier.newDebugger());
        boolean ignoreCachedValues = this.shouldReevaluate(toEvaluate);
        return ignoreCachedValues ? this.reevaluate(toEvaluate) : this.evaluateFromCache(toEvaluate);
    }

    private boolean shouldReevaluate(Value<?> toEvaluate) {
        try {
            return Optional.ofNullable((EvaluationFingerprint)this.cachedFingerprints.getIfPresent(toEvaluate)).map(fingerprints -> this.shouldReevaluate(toEvaluate, (EvaluationFingerprint)fingerprints)).orElse(true);
        }
        catch (RuntimeException e) {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = "stale due to exception"::toString;
            supplierArray[1] = e::toString;
            this.debugger.get().show(supplierArray);
            return true;
        }
    }

    private boolean shouldReevaluate(Value<?> toEvaluate, EvaluationFingerprint cachedFingerprint) {
        Boolean isUpToDate = this.isFingerprintUpToDate(toEvaluate, cachedFingerprint);
        if (!isUpToDate.booleanValue()) {
            cachedFingerprint.explain(this.debugger.get(), cachedFingerprint.take(this));
        }
        return isUpToDate == false;
    }

    private Boolean isFingerprintUpToDate(Value<?> toEvaluate, EvaluationFingerprint cachedFingerprint) {
        try {
            return cachedFingerprint.isUpToDate();
        }
        catch (RuntimeException runtimeException) {
            return false;
        }
    }

    private <R> Optional<R> evaluateFromCache(Value<R> toEvaluate) {
        EvaluationRequest request = new EvaluationRequest(false, this.fingerprintProvider.create(toEvaluate));
        Optional<R> requestResult = this.handleRequest(toEvaluate, request);
        return requestResult;
    }

    EvaluationFingerprint newFingerprint(Value<?> rootValue) {
        return this.fingerprintProvider.create(rootValue);
    }

    private EvaluationFingerprint newHashBasedFingerprint(Value<?> rootValue) {
        return new HashBasedFingerprint();
    }

    private EvaluationFingerprint newDebuggableFingerprint(Value<?> rootValue) {
        return new DebuggableEvaluationFingerprint(rootValue);
    }

    @Override
    public void cacheResult(Value<?> value, Optional<?> newValue) {
        this.cachedValues.put(value, newValue.get());
    }

    @Override
    public <R> Optional<R> getCachedResult(Value<R> value) {
        return Optional.ofNullable(this.cachedValues.getIfPresent(value));
    }

    @Override
    public void invalidateCachedResult(Value<?> value) {
        this.cachedValues.invalidate(value);
    }

    private <R> Optional<R> reevaluate(Value<R> toEvaluate) {
        EvaluationRequest request = new EvaluationRequest(true, this.fingerprintProvider.create(toEvaluate));
        Optional<R> result = this.handleRequest(toEvaluate, request);
        EvaluationFingerprint fingerprint = request.takeFingerprint(this);
        this.cachedFingerprints.put(toEvaluate, (Object)fingerprint);
        return result;
    }

    private <R> Optional<R> handleRequest(Value<R> toEvaluate, EvaluationRequest request) {
        Optional<R> optional;
        assert (this.evaluationRequest.get() == null);
        this.evaluationRequest.set(request);
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = ">>>>"::toString;
        supplierArray[1] = request::toString;
        this.debugger.get().show(supplierArray);
        try {
            optional = this.performComputation(toEvaluate);
            this.evaluationRequest.remove();
        }
        catch (Throwable throwable) {
            this.evaluationRequest.remove();
            Supplier[] supplierArray2 = new Supplier[1];
            supplierArray2[0] = "<<<<"::toString;
            this.debugger.get().show(supplierArray2);
            throw throwable;
        }
        Supplier[] supplierArray3 = new Supplier[1];
        supplierArray3[0] = "<<<<"::toString;
        this.debugger.get().show(supplierArray3);
        return optional;
    }

    private <R> Optional<R> doCompute(Value<R> toEvaluate) {
        return toEvaluate.compute(this);
    }

    private <R> Optional<R> monitorComputation(Value<R> toEvaluate) {
        return this.debugger.get().monitorComputation(toEvaluate, () -> this.doCompute(toEvaluate));
    }

    @Override
    public O outbound() {
        return this.outboundRequests;
    }

    @Override
    public <X> X getMetadata(Object key, Supplier<X> defaultValue) {
        return (X)this.valueMetadata.computeIfAbsent(key, value -> defaultValue.get());
    }

    public void setMetadata(Object key, Object newValue) {
        this.valueMetadata.put(key, newValue);
    }

    private static interface FingerprintProvider {
        public EvaluationFingerprint create(Value<?> var1);
    }

    private static interface ValueComputer {
        public <R> Optional<R> compute(Value<R> var1);
    }
}

