/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.value.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.mule.tooling.utils.value.EvaluationContext;
import org.mule.tooling.utils.value.impl.EvaluationFingerprint;

public class HashBasedFingerprint
extends EvaluationFingerprint {
    static final int INITIAL_HASH = 1;
    protected final int hash;

    protected HashBasedFingerprint(Map<Object, EvaluationFingerprint.Atom> atoms, int hash) {
        super(atoms);
        this.hash = hash;
    }

    public HashBasedFingerprint() {
        this.hash = 1;
    }

    @Override
    public boolean isUpToDate() {
        int computedHash = HashBasedFingerprint.computeHash(this.atoms, EvaluationFingerprint.Atom::getCurrentValue);
        boolean isUpToDate = this.hash == computedHash;
        return isUpToDate;
    }

    protected static int computeHash(Map<Object, EvaluationFingerprint.Atom> atomsToHash, Function<EvaluationFingerprint.Atom, Object> valueSupplier) {
        int computedHash = 1;
        for (EvaluationFingerprint.Atom current : atomsToHash.values()) {
            computedHash = HashBasedFingerprint.updateHash(computedHash, current, valueSupplier);
        }
        return computedHash;
    }

    private static int updateHash(int originalHash, EvaluationFingerprint.Atom toEvaluate, Function<EvaluationFingerprint.Atom, Object> valueSupplier) {
        int keyHash;
        int newHash = originalHash;
        Object key = toEvaluate.getKey();
        newHash = keyHash = key.hashCode();
        Object value = valueSupplier.apply(toEvaluate);
        int valueHash = value.hashCode();
        newHash = 31 * newHash + valueHash;
        return originalHash + 31 * newHash;
    }

    @Override
    public EvaluationFingerprint take(EvaluationContext context) {
        return new HashBasedFingerprint(this.atoms, HashBasedFingerprint.computeHash(this.atoms, EvaluationFingerprint.Atom::getCurrentValue));
    }

    public String toString() {
        return this.hash + " - " + String.valueOf(this.atoms);
    }

    protected Map<Object, EvaluationFingerprint.Atom> recomputedAtoms() {
        return this.atoms.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((EvaluationFingerprint.Atom)e.getValue()).recompute(), (a, b) -> a, LinkedHashMap::new));
    }
}

