/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.value.impl;

import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.mule.tooling.utils.value.EvaluationContext;
import org.mule.tooling.utils.value.Value;
import org.mule.tooling.utils.value.ValueException;
import org.mule.tooling.utils.value.impl.AbstractExceptionHandlingValue;

public class ExceptionHandlingValue<E extends Throwable, R>
extends AbstractExceptionHandlingValue<E, R> {
    private final Optional<BiConsumer<E, EvaluationContext>> handler;

    public ExceptionHandlingValue(Value<R> source, Predicate<E> filter, BiConsumer<E, EvaluationContext> handler) {
        super(source, filter);
        this.handler = Optional.ofNullable(handler);
    }

    @Override
    protected Optional<R> handleException(EvaluationContext context, ValueException e) {
        this.handler.ifPresent(it -> it.accept(e.getCause(), context));
        return Optional.empty();
    }
}

