/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.value.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.tooling.utils.value.EvaluationContext;

public abstract class EvaluationFingerprint {
    protected final Map<Object, Atom> atoms;

    protected EvaluationFingerprint() {
        this.atoms = new LinkedHashMap<Object, Atom>();
    }

    protected EvaluationFingerprint(Map<Object, Atom> atoms) {
        this.atoms = atoms;
    }

    public void trackValue(Atom toTrack) {
        this.atoms.put(toTrack.key, toTrack);
    }

    Atom getAtom(Atom sameAtom) {
        return this.atoms.get(sameAtom.key);
    }

    public Map<Object, Atom> getAtoms() {
        return this.atoms;
    }

    public abstract boolean isUpToDate();

    public abstract EvaluationFingerprint take(EvaluationContext var1);

    public void explain(EvaluationContext.Debugger debugger, EvaluationFingerprint latestFingerprint) {
    }

    public static class Atom {
        final Object key;
        private final Supplier<Optional<?>> valueProvider;
        Optional<?> valueSnapshot;

        public Atom(Object key, Supplier<Optional<?>> valueProvider, Optional<?> valueSnapshot) {
            this.key = key;
            this.valueProvider = valueProvider;
            this.valueSnapshot = valueSnapshot;
        }

        public Atom(Object key, Supplier<?> valueProvider) {
            this(key, () -> Optional.ofNullable(valueProvider.get()), Optional.ofNullable(valueProvider.get()));
        }

        public Object getKey() {
            return this.key;
        }

        public String toString() {
            return String.valueOf(this.key) + " = " + String.valueOf(this.valueSnapshot.orElse(null));
        }

        public Optional<?> getCurrentValue() {
            return this.valueProvider.get();
        }

        public Optional<?> getValueSnapshot() {
            return this.valueSnapshot;
        }

        Atom updated(Optional<?> newSnapshot) {
            return new Atom(this.key, this.valueProvider, newSnapshot);
        }

        public Atom recompute() {
            return this.updated(this.getCurrentValue());
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
            result = 31 * result + (this.valueSnapshot == null ? 0 : this.valueSnapshot.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Atom other = (Atom)obj;
            if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
                return false;
            }
            return !(this.valueSnapshot == null ? other.valueSnapshot != null : !this.valueSnapshot.equals(other.valueSnapshot));
        }
    }
}

