/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.value.impl;

import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.tooling.utils.value.EvaluationContext;
import org.mule.tooling.utils.value.Value;
import org.mule.tooling.utils.value.impl.EvaluationFingerprint;
import org.mule.tooling.utils.value.impl.HashBasedFingerprint;

public class DebuggableEvaluationFingerprint
extends HashBasedFingerprint {
    private Value<?> rootValue;

    public DebuggableEvaluationFingerprint(Value<?> rootValue) {
        this.rootValue = rootValue;
    }

    private DebuggableEvaluationFingerprint(Value<?> rootValue, Map<Object, EvaluationFingerprint.Atom> atoms, int hash) {
        super(atoms, hash);
        this.rootValue = rootValue;
    }

    @Override
    public DebuggableEvaluationFingerprint take(EvaluationContext context) {
        Map<Object, EvaluationFingerprint.Atom> newAtoms = this.recomputedAtoms();
        return new DebuggableEvaluationFingerprint(this.rootValue, newAtoms, DebuggableEvaluationFingerprint.computeHash(newAtoms, EvaluationFingerprint.Atom::getValueSnapshot));
    }

    @Override
    public void explain(EvaluationContext.Debugger debugger, EvaluationFingerprint latestFingerprint) {
        if (this.isUpToDate()) {
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = "UP TO DATE!"::toString;
            debugger.show(supplierArray);
        } else {
            LinkedHashSet<Object> addedKeys = new LinkedHashSet<Object>(latestFingerprint.atoms.keySet());
            addedKeys.removeAll(this.atoms.keySet());
            LinkedHashSet removedKeys = new LinkedHashSet(this.atoms.keySet());
            removedKeys.removeAll(latestFingerprint.atoms.keySet());
            LinkedHashSet<Object> changedKeys = new LinkedHashSet<Object>(latestFingerprint.atoms.keySet());
            changedKeys.removeAll(addedKeys);
            changedKeys.removeIf(key -> ((EvaluationFingerprint.Atom)this.atoms.get((Object)key)).valueSnapshot.equals(evaluationFingerprint.atoms.get((Object)key).valueSnapshot));
            BiFunction<Set, Map, Stream> keysToAtoms = (keys, map) -> keys.stream().map(map::get).filter(Objects::nonNull);
            Function<Stream, String> streamToString = stream -> stream.map(Object::toString).collect(Collectors.joining("\n"));
            BiFunction<Set, Map, String> keysToAtomString = keysToAtoms.andThen(streamToString);
            debugger.show("*** Added:\n" + keysToAtomString.apply(addedKeys, latestFingerprint.atoms));
            debugger.show("*** Removed:\n" + keysToAtomString.apply(removedKeys, this.atoms));
            String changedValues = keysToAtoms.apply(changedKeys, this.atoms).map(atom -> String.valueOf(atom.key) + "\n\tBefore: " + String.valueOf(atom.valueSnapshot) + "\n\tAfter: " + String.valueOf(evaluationFingerprint.getAtom((EvaluationFingerprint.Atom)atom).valueSnapshot)).collect(Collectors.joining("\n"));
            debugger.show("*** Changed:\n" + changedValues);
        }
    }

    @Override
    public String toString() {
        return this.rootValue.toString() + super.toString();
    }
}

