/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.value.impl;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.tooling.utils.value.EvaluationContext;
import org.mule.tooling.utils.value.Value;
import org.mule.tooling.utils.value.impl.AbstractValue;

public class CompositeValue<O>
extends AbstractValue<O> {
    private final List<? extends Value<O>> alternatives;

    @Override
    public Optional<O> compute(EvaluationContext context) {
        Optional result = this.alternatives.stream().map(it -> context.evaluateUpstream(it)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
        return result;
    }

    public CompositeValue(List<? extends Value<O>> alternatives) {
        this.alternatives = alternatives;
    }

    @SafeVarargs
    public CompositeValue(Value<O> ... alternatives) {
        this(Arrays.asList(alternatives));
    }

    public CompositeValue(Stream<Value<O>> alternatives) {
        this(alternatives.collect(Collectors.toList()));
    }
}

