/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.value.impl;

import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.mule.tooling.utils.value.EvaluationContext;
import org.mule.tooling.utils.value.Value;
import org.mule.tooling.utils.value.impl.AbstractValue;

public class CombinedValue<T1, T2, T>
extends AbstractValue<T> {
    private final BiFunction<T1, T2, T> combiner;
    private final Value<T1> parameter1;
    private final Value<T2> parameter2;

    public CombinedValue(Value<T1> parameter1, Value<T2> parameter2, BiFunction<T1, T2, T> combiner) {
        this.parameter1 = parameter1;
        this.parameter2 = parameter2;
        this.combiner = combiner;
    }

    @Override
    public Optional<T> compute(EvaluationContext context) {
        return context.evaluateUpstream(this.parameter1).map(it -> CombinedValue.partialApply(this.combiner, it)).flatMap(fun -> context.evaluateUpstream(this.parameter2).map(fun));
    }

    private static <X, Y, Z> Function<Y, Z> partialApply(BiFunction<X, Y, Z> toApply, X x) {
        return y -> toApply.apply(x, y);
    }
}

