/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.value.impl;

import java.util.Optional;
import org.mule.tooling.utils.value.EvaluationContext;
import org.mule.tooling.utils.value.Value;
import org.mule.tooling.utils.value.impl.DecoratedValue;

public abstract class CachedValue<T>
extends DecoratedValue<T, T> {
    public CachedValue(Value<T> source) {
        super(source);
    }

    protected abstract boolean isStale(EvaluationContext var1, T var2);

    protected Optional<T> recompute(EvaluationContext context) {
        Optional newValue = this.evaluateSource(context);
        if (newValue.isPresent()) {
            context.cacheResult(this, newValue);
        }
        return newValue;
    }

    @Override
    public final Optional<T> compute(EvaluationContext context) {
        Optional cached;
        boolean ignoreCachedValues = this.ignoreCachedValues(context);
        if (!ignoreCachedValues && (cached = context.getCachedResult(this)) != null && cached.isPresent() && !this.isStale(context, cached.get())) {
            return cached;
        }
        return this.recompute(context);
    }

    protected boolean ignoreCachedValues(EvaluationContext context) {
        return context.ignoreCachedValues();
    }
}

