/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.value.impl;

import java.util.Arrays;
import java.util.Optional;
import java.util.stream.Stream;
import org.mule.tooling.utils.value.Value;

public abstract class AbstractValue<R>
implements Value<R> {
    private String description = this.describe(3);

    @Override
    public Value<R> described() {
        this.description = this.describe(1);
        return this;
    }

    @Override
    public Value<R> described(String description) {
        this.description = description;
        return this;
    }

    private String describe(int framesToSkip) {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        Stream<StackTraceElement> skippingImplementation = Arrays.stream(stackTrace).skip(1L).filter(it -> !it.getClassName().startsWith(this.getClass().getPackage().getName()));
        Optional<StackTraceElement> firstFrame = skippingImplementation.filter(it -> !it.getClassName().equals(Value.class.getName())).findFirst();
        String callerName = firstFrame.map(f -> Arrays.stream(f.getClassName().split("\\.")).reduce("", (a, b) -> b) + "#" + f.getMethodName()).orElse("");
        return callerName + " : " + this.getClass().getSimpleName();
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.getDescription();
    }
}

