/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.value.impl;

import java.util.Optional;
import java.util.function.Predicate;
import org.mule.tooling.utils.value.EvaluationContext;
import org.mule.tooling.utils.value.Value;
import org.mule.tooling.utils.value.ValueException;
import org.mule.tooling.utils.value.impl.DownstreamValue;

abstract class AbstractExceptionHandlingValue<E extends Throwable, R>
extends DownstreamValue<R, R> {
    private Predicate<E> filter;

    public AbstractExceptionHandlingValue(Value<R> upstream, Predicate<E> filter) {
        super(upstream);
        this.filter = filter;
    }

    @Override
    public Optional<R> compute(EvaluationContext context) {
        try {
            return this.evaluateUpstream(context);
        }
        catch (ValueException e) {
            if (this.filter.test(e.getCause())) {
                return this.handleException(context, e);
            }
            throw e;
        }
    }

    protected abstract Optional<R> handleException(EvaluationContext var1, ValueException var2);
}

