/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.value.caching;

import java.util.Optional;
import org.mule.tooling.utils.value.EvaluationContext;
import org.mule.tooling.utils.value.caching.AbstractCachePolicy;

public class StampCachePolicy<T, S>
extends AbstractCachePolicy<T> {
    private final StampValidator<S> stampValidator;
    private final StampProvider<T, S> stampProvider;

    public StampCachePolicy(ContextFreeStampProvider<T, S> stampProvider, StampValidator<S> stampValidator) {
        this((EvaluationContext context, T value) -> stampProvider.stamp(value), stampValidator);
    }

    public StampCachePolicy(StampProvider<T, S> stampProvider, StampValidator<S> stampValidator) {
        this.stampValidator = stampValidator;
        this.stampProvider = stampProvider;
    }

    @Override
    public boolean isStale(T cachedValue, EvaluationContext context) {
        S lastStamp = this.getLastStamp(context);
        return lastStamp == null || Optional.ofNullable(this.computeStamp(cachedValue, context)).map(newStamp -> this.isStampStale(lastStamp, newStamp)).orElse(true) != false;
    }

    private boolean isStampStale(S lastStamp, S newStamp) {
        boolean isValid = this.stampValidator.isValidStamp(lastStamp, newStamp);
        return !isValid;
    }

    private S computeStamp(T cachedValue, EvaluationContext context) {
        S newStamp = this.stampProvider.stamp(context, cachedValue);
        return newStamp;
    }

    @Override
    public void updated(Optional<T> newValue, EvaluationContext context) {
        S newStamp = newValue.map(v -> this.computeStamp(v, context)).orElse(null);
        this.setLastStamp(context, newStamp);
    }

    private S getLastStamp(EvaluationContext context) {
        return (S)context.getMetadata(this);
    }

    private void setLastStamp(EvaluationContext context, S newStamp) {
        context.setMetadata(this, newStamp);
    }

    @FunctionalInterface
    public static interface ContextFreeStampProvider<T, S> {
        public S stamp(T var1);
    }

    @FunctionalInterface
    public static interface StampProvider<T, S> {
        public S stamp(EvaluationContext var1, T var2);
    }

    @FunctionalInterface
    public static interface StampValidator<S> {
        public boolean isValidStamp(S var1, S var2);
    }
}

