/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.value.caching;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileTime;

class FileStamp {
    private String path;
    private FileTime timestamp;
    private long size;

    public FileStamp(Path path, FileTime timestamp, long size) {
        this.path = path.toString();
        this.timestamp = timestamp;
        this.size = size;
    }

    public static boolean similar(FileStamp thisStamp, FileStamp other) {
        return thisStamp.size == other.size && thisStamp.timestamp.compareTo(other.timestamp) == 0 && thisStamp.path.equals(other.path);
    }

    static FileStamp generateStamp(File path) {
        return FileStamp.generateStamp(path.toPath());
    }

    static FileStamp generateStamp(Path path) {
        try {
            return new FileStamp(path, Files.getLastModifiedTime(path, new LinkOption[0]), Files.size(path));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public String toString() {
        return this.path + " - size: " + this.size + " - timestamp: " + String.valueOf(this.timestamp);
    }
}

