/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.value.caching;

import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import org.mule.tooling.utils.value.EvaluationContext;
import org.mule.tooling.utils.value.caching.AbstractCachePolicy;

public class ExpiringCachePolicy<T>
extends AbstractCachePolicy<T> {
    private final Duration durationThreshold;

    public ExpiringCachePolicy(Duration durationThreshold) {
        this.durationThreshold = durationThreshold;
    }

    @Override
    public boolean isStale(T cachedValue, EvaluationContext context) {
        Instant valueTimestamp = (Instant)context.getMetadata(this, null);
        boolean nullTimestamp = valueTimestamp == null;
        boolean stale = nullTimestamp || valueTimestamp.plus(this.durationThreshold).isBefore(Instant.now());
        return stale;
    }

    @Override
    public void updated(Optional<T> newValue, EvaluationContext context) {
        context.setMetadata(this, Instant.now());
    }
}

