/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.value;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.mule.tooling.utils.value.EvaluationContext;
import org.mule.tooling.utils.value.PairedValue;
import org.mule.tooling.utils.value.PredicatedValue;
import org.mule.tooling.utils.value.ValueException;
import org.mule.tooling.utils.value.caching.CachePolicy;
import org.mule.tooling.utils.value.caching.ExpiringCachePolicy;
import org.mule.tooling.utils.value.caching.StampCachePolicy;
import org.mule.tooling.utils.value.impl.CombinedValue;
import org.mule.tooling.utils.value.impl.CompositeValue;
import org.mule.tooling.utils.value.impl.ConditionalValue;
import org.mule.tooling.utils.value.impl.ConstantValue;
import org.mule.tooling.utils.value.impl.ExceptionHandlingValue;
import org.mule.tooling.utils.value.impl.ExternalValue;
import org.mule.tooling.utils.value.impl.FallbackValue;
import org.mule.tooling.utils.value.impl.InvalidValue;
import org.mule.tooling.utils.value.impl.MappedValue;
import org.mule.tooling.utils.value.impl.PairMappedValue;
import org.mule.tooling.utils.value.impl.PolicyBasedCachedValue;
import org.mule.tooling.utils.value.impl.ValidatedValue;

public interface Value<R> {
    public Optional<R> compute(EvaluationContext var1);

    default public boolean isTrivial() {
        return false;
    }

    default public <R2> Value<R2> mapped(Function<R, R2> mapper) {
        return new MappedValue<R, R2>(this, mapper);
    }

    default public <R1, R2> Value<R2> combined(Value<R1> parameter, BiFunction<R, R1, R2> combiner) {
        return new CombinedValue<R, R1, R2>(this, parameter, combiner);
    }

    default public <R1, R2> PairedValue<R1, R2> pairUp(Function<R, R1> componentExtractor1, Function<R, R2> componentExtractor2) {
        return new PairMappedValue<R, R1, R2>(this, componentExtractor1, componentExtractor2);
    }

    public static <I, R, E extends Exception> Function<I, R> unchecked(ThrowingFunction<I, R, E> mapper) {
        return mapper.safe();
    }

    public static <R, E extends Throwable> Supplier<R> unchecked(ThrowingSupplier<R, E> supplier) {
        return supplier.safe();
    }

    public static <I1, I2, R> BiFunction<I1, I2, R> unchecked(ThrowingBiFunction<I1, I2, R> mapper) {
        return mapper.safe();
    }

    default public <E extends Exception> Value<R> catching(Predicate<E> filter, Value<R> fallback) {
        return this.catching(filter, null, fallback);
    }

    default public <E extends Throwable> Value<R> catching(Predicate<E> filter, BiConsumer<E, EvaluationContext> handler, Value<R> fallback) {
        return new FallbackValue<E, R>(this, filter, handler, fallback);
    }

    public static <T extends Throwable> Predicate<T> instanceOf(Collection<Class<? extends T>> types) {
        return it -> types.contains(it.getClass());
    }

    default public <E extends Exception> Value<R> catchingAll(Value<R> fallback) {
        return new FallbackValue<Throwable, R>(this, Objects::nonNull, null, fallback);
    }

    default public <E extends Exception> Value<R> ignoring(Predicate<E> predicate) {
        return new ExceptionHandlingValue(this, predicate, null);
    }

    default public <E extends Exception> Value<R> ignoringAll() {
        return new ExceptionHandlingValue(this, Objects::nonNull, null);
    }

    default public PredicatedValue<R> provided(Predicate<R> validator) {
        return new ValidatedValue<R>(this, validator);
    }

    default public <C extends EvaluationContext.OutboundRequests> PredicatedValue<R> required(Predicate<C> condition) {
        return new ConditionalValue(this, condition);
    }

    default public Value<R> cached(Duration threshold) {
        return this.cached(new ExpiringCachePolicy(threshold));
    }

    default public <S> Value<R> cached(StampCachePolicy.StampValidator<S> stampValidator, StampCachePolicy.StampProvider<R, S> stamper) {
        return this.cached(new StampCachePolicy<R, S>(stamper, stampValidator));
    }

    default public <S> Value<R> cached(StampCachePolicy.StampValidator<S> stampValidator, StampCachePolicy.ContextFreeStampProvider<R, S> stamper) {
        return this.cached(new StampCachePolicy<R, S>(stamper, stampValidator));
    }

    default public Value<R> cached(CachePolicy<R> first) {
        return new PolicyBasedCachedValue<R>(this, first);
    }

    default public Value<R> cached(List<CachePolicy<R>> policies) {
        return new PolicyBasedCachedValue(this, policies);
    }

    default public Value<R> described(String name) {
        return this.described(name);
    }

    default public Value<R> described() {
        return this.described();
    }

    default public Value<R> constant() {
        return new ConstantValue(this);
    }

    public static <O extends EvaluationContext.OutboundRequests, R> Value<R> trivial(Supplier<R> computer) {
        return Value.trivial((O context) -> computer.get());
    }

    public static <O extends EvaluationContext.OutboundRequests, R> Value<R> trivial(Function<O, R> computer) {
        return new ExternalValue<O, R>(computer, true);
    }

    public static <O extends EvaluationContext.OutboundRequests, R> Value<R> blocking(Supplier<R> computer) {
        return Value.blocking((O context) -> computer.get());
    }

    public static <O extends EvaluationContext.OutboundRequests, R> Value<R> blocking(Function<O, R> computer) {
        return new ExternalValue<O, R>(computer, false);
    }

    @SafeVarargs
    public static <R> Value<R> options(Value<R> ... options) {
        return new CompositeValue<R>(options);
    }

    public static <R> Value<R> invalid(Supplier<String> error) {
        return new InvalidValue(error);
    }

    public String getDescription();

    @FunctionalInterface
    public static interface ThrowingBiFunction<P1, P2, R> {
        public R apply(P1 var1, P2 var2) throws Throwable;

        default public BiFunction<P1, P2, R> safe() {
            return (p1, p2) -> {
                try {
                    return this.apply(p1, p2);
                }
                catch (Throwable e) {
                    throw new ValueException(e);
                }
            };
        }
    }

    @FunctionalInterface
    public static interface ThrowingFunction<T, R, E extends Throwable> {
        public R apply(T var1) throws E;

        default public Function<T, R> safe() {
            return t -> {
                try {
                    return this.apply(t);
                }
                catch (Throwable e) {
                    throw new ValueException(e);
                }
            };
        }
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<R, E extends Throwable> {
        public R supply() throws E;

        default public Supplier<R> safe() {
            return () -> {
                try {
                    return this.supply();
                }
                catch (Throwable e) {
                    throw new ValueException(e);
                }
            };
        }
    }
}

