/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.value;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import org.mule.tooling.utils.value.EvaluationDebugger;
import org.mule.tooling.utils.value.Value;

public interface EvaluationContext {
    public <O extends OutboundRequests> O outbound();

    default public <R> Optional<R> evaluate(Value<R> toEvaluate) {
        return toEvaluate.compute(this);
    }

    default public <R> Optional<R> evaluateUpstream(Value<R> toEvaluate) {
        return toEvaluate.compute(this);
    }

    public boolean ignoreCachedValues();

    public void cacheResult(Value<?> var1, Optional<?> var2);

    public <R> Optional<R> getCachedResult(Value<R> var1);

    public void invalidateCachedResult(Value<?> var1);

    default public <X> X getMetadata(Object key) {
        return (X)this.getMetadata(key, () -> null);
    }

    public <X> X getMetadata(Object var1, Supplier<X> var2);

    public <X> void setMetadata(Object var1, X var2);

    public <EC extends EvaluationContext> EC debugging(EvaluationDebugger.Factory var1);

    public static interface Debugger {
        public void show(Supplier<Object> ... var1);

        default public void show(Object ... values) {
            this.show((Supplier[])Arrays.stream(values).map(it -> it::toString).toArray(Supplier[]::new));
        }
    }

    public static interface OutboundRequests {
    }
}

