/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.script;

public class ScriptUtils {
    public static final String SUFIX = "]";
    public static final String PREFIX = "#[";
    public static final char START_EXPRESSION = '#';
    public static final char OPEN_EXPRESSION = '[';
    public static final char CLOSE_EXPRESSION = ']';

    private ScriptUtils() {
    }

    public static boolean isScript(String text) {
        return text != null && text.startsWith(PREFIX) && text.endsWith(SUFIX) && ScriptUtils.getFirstScript(text).equals(text);
    }

    public static String toScript(String text) {
        if (!ScriptUtils.isScript(text)) {
            return PREFIX + text + SUFIX;
        }
        return text;
    }

    public static String getScriptContent(String text) {
        if (ScriptUtils.isScript(text)) {
            return text.substring(PREFIX.length(), text.length() - SUFIX.length()).trim();
        }
        return null;
    }

    public static String getScriptContentOrText(String text) {
        if (ScriptUtils.isScript(text)) {
            return text.substring(PREFIX.length(), text.length() - SUFIX.length()).trim();
        }
        return text;
    }

    public static boolean isPayloadScript(String script) {
        if (ScriptUtils.isScript(script)) {
            script = ScriptUtils.getScriptContent(script);
        }
        return "payload".equals(script);
    }

    public static boolean isSingleLineScript(String value) {
        return !value.chars().anyMatch(c -> c == 10 || c == 13);
    }

    private static String getFirstScript(String script) {
        StringBuilder expressionBuilder = new StringBuilder();
        boolean isStartOfExpression = false;
        boolean skipChar = false;
        int openBraces = 0;
        int i = 0;
        while (i < script.length()) {
            char c = script.charAt(i);
            switch (c) {
                case ']': {
                    if (openBraces <= 0) break;
                    --openBraces;
                    break;
                }
                case '[': {
                    if (!isStartOfExpression && openBraces <= 0 || ++openBraces != 1) break;
                    skipChar = true;
                }
            }
            if (openBraces > 0) {
                if (!skipChar) {
                    expressionBuilder.append(c);
                } else {
                    skipChar = false;
                }
            } else if (openBraces == 0 && expressionBuilder.length() > 0) {
                return PREFIX + expressionBuilder.toString() + SUFIX;
            }
            isStartOfExpression = c == '#';
            ++i;
        }
        return script;
    }
}

