/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.lang.reflect.FieldUtils;
import org.mule.tooling.utils.UtilsPlugin;
import org.osgi.framework.Bundle;

public class ReflectionUtils {
    private ReflectionUtils() {
    }

    public static Field searchFieldByName(Class<?> className, String fieldName) {
        Field declaredField = null;
        try {
            declaredField = className.getDeclaredField(fieldName);
        }
        catch (SecurityException e) {
            UtilsPlugin.logError("Error while using reflection over " + className.getName(), e);
        }
        catch (NoSuchFieldException noSuchFieldException) {}
        if (declaredField == null && className.getSuperclass() != null) {
            return ReflectionUtils.searchFieldByName(className.getSuperclass(), fieldName);
        }
        return declaredField;
    }

    public static Method searchMethod(Class<?> className, String methodName, int numberOfArguments) {
        return ReflectionUtils.searchMethodBy(className, methodName, method -> method.getParameterTypes().length == numberOfArguments);
    }

    public static Method searchMethod(Class<?> className, String methodName, Class<?> ... parameterTypes) {
        return ReflectionUtils.searchMethodBy(className, methodName, method -> Arrays.equals(method.getParameterTypes(), parameterTypes));
    }

    private static Method searchMethodBy(Class<?> className, String methodName, Predicate<Method> methodFilter) {
        Method[] declaredMethods;
        Method[] methodArray = declaredMethods = className.getDeclaredMethods();
        int n = declaredMethods.length;
        int n2 = 0;
        while (n2 < n) {
            Method method = methodArray[n2];
            if (method.getName().equals(methodName) && methodFilter.test(method)) {
                return method;
            }
            ++n2;
        }
        if (className.getSuperclass() != null) {
            return ReflectionUtils.searchMethodBy(className.getSuperclass(), methodName, methodFilter);
        }
        return null;
    }

    public static boolean isAssignableFrom(Class<?> fieldType, Object parameter) {
        boolean isAssignable = fieldType.isPrimitive() ? ReflectionUtils.isAssignableFromPrimitive(parameter, fieldType) : fieldType.isAssignableFrom(parameter.getClass());
        return isAssignable;
    }

    public static boolean isAssignableFromPrimitive(Object parameter, Class<?> fieldType) {
        Class primitiveTypeWrapper = ClassUtils.primitiveToWrapper(fieldType);
        Class<?> parameterClass = parameter.getClass();
        return primitiveTypeWrapper.isAssignableFrom(parameterClass);
    }

    public static void invokeMethod(String methodName, Object targetObject) {
        try {
            Method method = targetObject.getClass().getDeclaredMethod(methodName, new Class[0]);
            ReflectionUtils.invokeMethod(targetObject, method, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(MessageFormat.format("Method {0} not found in class {1}", methodName, targetObject.getClass().getName()), e);
        }
        catch (IllegalArgumentException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public static Object invokeMethod(Object targetObject, Method method, Object ... arguments) {
        if (!method.isAccessible()) {
            method.setAccessible(true);
        }
        try {
            return method.invoke(targetObject, arguments);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static void setField(String fieldName, Object newValue, Object target) {
        try {
            FieldUtils.writeField((Object)target, (String)fieldName, (Object)newValue, (boolean)true);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void invokeSetter(String fieldName, Class<?> fieldType, Object parameter, Object targetObject) {
        try {
            String fieldNameFirstCharUppercase = String.valueOf(fieldName.charAt(0)).toUpperCase();
            String fieldNameAllButFirst = fieldName.substring(1, fieldName.length());
            String setterName = "set" + fieldNameFirstCharUppercase + fieldNameAllButFirst;
            Method setter = ReflectionUtils.searchMethod(targetObject.getClass(), setterName, fieldType);
            if (setter != null) {
                if (!setter.isAccessible()) {
                    setter.setAccessible(true);
                }
            } else {
                throw new RuntimeException("You must define a setter method for annotated fields that you wish to be injected into your contribution. Field: " + fieldName + " in type " + targetObject.getClass().getName());
            }
            setter.invoke(targetObject, parameter);
        }
        catch (IllegalAccessException | IllegalArgumentException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<Field> getAnnotatedFields(Class<?> type, Class<? extends Annotation> annotation) {
        ArrayList<Field> allFields = new ArrayList<Field>();
        Class<?> currentType = type;
        do {
            List<Field> annotatedFields = ReflectionUtils.doGetAnnotatedFields(currentType, annotation);
            allFields.addAll(annotatedFields);
        } while ((currentType = currentType.getSuperclass()) != null);
        return allFields;
    }

    private static List<Field> doGetAnnotatedFields(Class<?> type, Class<? extends Annotation> annotation) {
        Field[] declaredFields = type.getDeclaredFields();
        ArrayList<Field> annotatedFields = new ArrayList<Field>();
        Field[] fieldArray = declaredFields;
        int n = declaredFields.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray[n2];
            if (field.isAnnotationPresent(annotation)) {
                annotatedFields.add(field);
            }
            ++n2;
        }
        return annotatedFields;
    }

    public static boolean hasEmptyConstructor(Class<?> elementType) {
        try {
            Constructor<?> constructor = elementType.getDeclaredConstructor(new Class[0]);
            return constructor != null && (constructor.getModifiers() & 1) != 0;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return false;
        }
        catch (SecurityException e) {
            throw new RuntimeException("There was a problem checking class " + elementType.getName() + " for empty constructor, message: " + e.getMessage(), e);
        }
    }

    public static boolean isAbstractClass(Class<?> elementType) {
        return !elementType.isInterface() && (elementType.getModifiers() & 0x400) != 0;
    }

    public static <T> T newInstance(Class<T> actionClass) {
        try {
            return actionClass.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T newInstance(Bundle bundle, String typeName) {
        try {
            Class type = bundle.loadClass(typeName);
            return ReflectionUtils.newInstance(type);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

