/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.lifecycle;

import java.io.File;
import java.net.URISyntaxException;
import javax.lang.model.SourceVersion;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.ui.workbench.lifecycle.PostContextCreate;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.mule.tooling.utils.OSInstallationVerifier;
import org.mule.tooling.utils.OsDetect;
import org.mule.tooling.utils.UtilsPlugin;
import org.mule.tooling.utils.lifecycle.JdkErrorDialog;

public class LifeCycleManager {
    private static final String MAC_SUB_TEXT = "Please move AnypointStudio.app to Applications folder and re launch.";
    private static final String OTHER_SUB_TEXT = "Please move Anypoint Studio to a location where you have read and write permissions.";

    @PostContextCreate
    void postContextCreate(IApplicationContext appContext, Display display) {
        boolean canWrite = true;
        try {
            canWrite = new File(Platform.getInstallLocation().getURL().toURI()).canWrite();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        if (!canWrite) {
            final String subTextMessage = OsDetect.getOperatingSystemType().equals((Object)OsDetect.OsType.OSX) ? MAC_SUB_TEXT : OTHER_SUB_TEXT;
            MessageDialog messageDialog = new MessageDialog(null, "Warning", null, "Anypoint Studio is running on a read only folder and many features won't work as expected.", 4, 0, new String[]{"Exit"}){

                protected Control createMessageArea(Composite composite) {
                    LocalResourceManager resManager = new LocalResourceManager(JFaceResources.getResources(), (Control)composite);
                    Control createMessageArea = super.createMessageArea(composite);
                    Composite messageComposite = (Composite)createMessageArea;
                    Label subtextLabel = new Label(messageComposite, 64);
                    FontDescriptor boldDescriptor = FontDescriptor.createFrom((Font)subtextLabel.getFont()).setStyle(1);
                    Font boldFont = resManager.createFont(boldDescriptor);
                    subtextLabel.setText(subTextMessage);
                    subtextLabel.setFont(boldFont);
                    GridDataFactory.fillDefaults().align(0x1000000, 1).span(2, 1).grab(true, false).applyTo((Control)subtextLabel);
                    return createMessageArea;
                }
            };
            messageDialog.open();
            System.exit(-1);
        }
        this.checkJDK();
        OSInstallationVerifier.verifyInstallation(appContext);
    }

    private void checkJDK() {
        boolean hasJdk17;
        boolean isJdk = UtilsPlugin.isRunningJdk();
        if (!isJdk) {
            this.openJdkDialog();
        }
        boolean bl = hasJdk17 = SourceVersion.RELEASE_17.compareTo(SourceVersion.latestSupported()) <= 0;
        if (!hasJdk17) {
            this.openJdkVersionDialog();
        }
    }

    private void openJdkVersionDialog() {
        String javaPath = System.getProperty("java.home");
        JdkErrorDialog.openError(null, "Incorrect Java version", "Anypoint Studio requires JDK 17 and is currently using the following path configuration: " + javaPath + "\nPlease change your configuration to use the correct version.");
        System.exit(-1);
    }

    private void openJdkDialog() {
        MessageDialog messageDialog = new MessageDialog(null, "Anypoint Studio 7", null, "A Java Development Kit (JDK) must be installed in order to run Anypoint Studio. \nPlease install a JDK and try again.\n", 0, 0, new String[]{"Ok"}){

            protected Control createMessageArea(Composite composite) {
                Control createMessageArea = super.createMessageArea(composite);
                Composite messageComposite = (Composite)createMessageArea;
                Composite linkComposite = new Composite(messageComposite, 0);
                GridLayoutFactory.fillDefaults().numColumns(2).spacing(-1, -1).applyTo(linkComposite);
                Label label = new Label(linkComposite, 64);
                label.setText("For more information about installation requirements, go to ");
                Link link = new Link(linkComposite, 64);
                link.setText("<a>documentation site.</a>");
                link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        try {
                            Program.launch((String)"https://docs.mulesoft.com/studio/latest/change-jdk-for-studio");
                        }
                        catch (Exception exception) {}
                    }
                });
                GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)link);
                GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)label);
                GridDataFactory.fillDefaults().align(1, 1).span(2, 1).applyTo((Control)linkComposite);
                return createMessageArea;
            }
        };
        messageDialog.open();
        System.exit(-1);
    }
}

