/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.lang;

import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import org.mule.tooling.utils.lang.ThreadLocalPrintStream;
import org.mule.tooling.utils.lang.ThreadLocalProperties;

public class ThreadLocalSystem {
    private static volatile ThreadLocalSystem instance;
    private static final AtomicInteger userCount;
    private final ThreadLocalPrintStream threadLocalOut = new ThreadLocalPrintStream(System.out);
    private final ThreadLocalPrintStream threadLocalErr = new ThreadLocalPrintStream(System.err);
    private final Properties originalProperties = System.getProperties();
    private final ThreadLocalProperties threadLocalProperties = new ThreadLocalProperties(this.originalProperties);

    static {
        userCount = new AtomicInteger(0);
    }

    private ThreadLocalSystem() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ThreadLocalSystem get(OutputStream out, OutputStream err) {
        ThreadLocalSystem tlSystem;
        AtomicInteger atomicInteger = userCount;
        synchronized (atomicInteger) {
            tlSystem = instance;
            if (tlSystem == null) {
                tlSystem = new ThreadLocalSystem();
                tlSystem.initialize(out, err);
                System.setOut(tlSystem.getOut());
                System.setErr(tlSystem.getErr());
                System.setProperties(tlSystem.getProperties());
                instance = tlSystem;
            } else {
                tlSystem.initialize(out, err);
            }
            userCount.incrementAndGet();
        }
        return tlSystem;
    }

    private void initialize(OutputStream out, OutputStream err) {
        this.getOut().set(new PrintStream(out));
        this.getErr().set(new PrintStream(err));
        Properties propertiesCopy = new Properties();
        propertiesCopy.putAll((Map<?, ?>)this.originalProperties);
        this.getProperties().set(propertiesCopy);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        AtomicInteger atomicInteger = userCount;
        synchronized (atomicInteger) {
            this.getOut().dispose();
            this.getErr().dispose();
            this.getProperties().dispose();
            int users = userCount.decrementAndGet();
            if (users == 0) {
                System.setOut(this.getOut().get());
                System.setErr(this.getErr().get());
                System.setProperties(this.getProperties().get());
                instance = null;
            }
        }
    }

    public ThreadLocalPrintStream getOut() {
        return this.threadLocalOut;
    }

    public ThreadLocalPrintStream getErr() {
        return this.threadLocalErr;
    }

    public ThreadLocalProperties getProperties() {
        return this.threadLocalProperties;
    }
}

