/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.lang;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;

public class StringUtilities {
    public static List<String> splitStringRespectingQuotes(String command, String separatorRegex) {
        HashMap<String, String> parenthesesReplacementsMap = new HashMap<String, String>();
        String safeSymbol = StringUtilities.findSafeSymbol(command);
        String commandLineWithoutQuotedArgs = StringUtilities.replaceQuotedStrings(command, parenthesesReplacementsMap, safeSymbol);
        String[] splitCommands = commandLineWithoutQuotedArgs.split(separatorRegex);
        String[] finalCommands = StringUtilities.restoreQuotedStrings(splitCommands, parenthesesReplacementsMap, safeSymbol);
        return Arrays.stream(finalCommands).filter(element -> StringUtils.isNotBlank((String)element)).collect(Collectors.toList());
    }

    private static String replaceQuotedStrings(String rawCommandArguments, Map<String, String> parenthesesReplacementsMap, String symbol) {
        return StringUtilities.replaceQuotedStrings(rawCommandArguments, parenthesesReplacementsMap, symbol, 0);
    }

    private static String findSafeSymbol(String rawCommandArguments) {
        char symbol = '\"';
        boolean foundSafeSymbol = false;
        while (!(foundSafeSymbol && symbol == '$' && symbol == '\\' || symbol >= '~')) {
            boolean bl = foundSafeSymbol = !rawCommandArguments.matches(".*" + StringUtilities.getEscapeSequenceRegex(String.valueOf(symbol = (char)(symbol + 1))) + ".*");
        }
        if (!foundSafeSymbol) {
            throw new RuntimeException("Could not find any ascii symbol to use as replacement");
        }
        return String.valueOf(symbol);
    }

    private static String getEscapeSequenceRegex(String symbol) {
        String escapedSymbol = Pattern.quote(symbol);
        return "(" + escapedSymbol + "[0-9]+" + escapedSymbol + ")";
    }

    private static String[] restoreQuotedStrings(String[] splitCommandLines, Map<String, String> parent, String safeSymbol) {
        Pattern escapeSequencePattern = Pattern.compile(StringUtilities.getEscapeSequenceRegex(safeSymbol));
        int i = 0;
        while (i < splitCommandLines.length) {
            Matcher matcher = escapeSequencePattern.matcher(splitCommandLines[i]);
            if (matcher.find()) {
                String replacement = parent.get(matcher.group(1));
                splitCommandLines[i] = matcher.replaceFirst(Matcher.quoteReplacement(replacement));
                --i;
            }
            ++i;
        }
        return splitCommandLines;
    }

    private static String replaceQuotedStrings(String rawCommandArguments, Map<String, String> parenthesesReplacementsMap, String symbol, int index) {
        Pattern quotedArgPattern = Pattern.compile("\".+?\"");
        Matcher parenthesisMatcher = quotedArgPattern.matcher(rawCommandArguments);
        String localExpression = rawCommandArguments;
        if (parenthesisMatcher.find()) {
            String parenthesisExpression = parenthesisMatcher.group(0);
            String key = symbol + index + symbol;
            localExpression = parenthesisMatcher.replaceFirst(key);
            parenthesesReplacementsMap.put(key, parenthesisExpression);
            return StringUtilities.replaceQuotedStrings(localExpression, parenthesesReplacementsMap, symbol, index + 1);
        }
        return localExpression;
    }
}

