/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.lang;

import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.mule.tooling.utils.lang.SafeCloseable;

public class ConvertibleReadWriteLock {
    private ReadWriteLock lock;

    public static ConvertibleReadWriteLock create() {
        return ConvertibleReadWriteLock.create(new ReentrantReadWriteLock(false));
    }

    public static ConvertibleReadWriteLock createFair() {
        return ConvertibleReadWriteLock.create(new ReentrantReadWriteLock(true));
    }

    public static ConvertibleReadWriteLock create(ReadWriteLock readWriteLock) {
        Objects.requireNonNull(readWriteLock);
        return new ConvertibleReadWriteLock(readWriteLock);
    }

    private ConvertibleReadWriteLock(ReadWriteLock lock) {
        this.lock = lock;
    }

    public UpgradingLock lockForReadLevel() {
        Lock readLock = this.lock.readLock();
        readLock.lock();
        return UpgradingLock.fromReadLock(this.lock, readLock);
    }

    public SafeCloseable lockForWriteLevel() {
        Lock writeLock = this.lock.writeLock();
        writeLock.lock();
        return UpgradingLock.fromWriteLock(this.lock, writeLock);
    }

    public static class UpgradingLock
    implements SafeCloseable {
        private final ReadWriteLock readWriteLock;
        private final Lock readLock;
        private Lock writeLock;

        public static UpgradingLock fromReadLock(ReadWriteLock readWriteLock, Lock readLock) {
            return new UpgradingLock(readWriteLock, readLock, null);
        }

        public static UpgradingLock fromWriteLock(ReadWriteLock readWriteLock, Lock writeLock) {
            return new UpgradingLock(readWriteLock, null, writeLock);
        }

        private UpgradingLock(ReadWriteLock readWriteLock, Lock readLock, Lock writeLock) {
            this.readWriteLock = readWriteLock;
            this.readLock = readLock;
            this.writeLock = writeLock;
        }

        public void upgradeLockToWriteLevel() {
            this.writeLock = this.readWriteLock.writeLock();
            this.readLock.unlock();
            this.writeLock.lock();
        }

        public void unlock() {
            if (this.writeLock != null) {
                this.writeLock.unlock();
            } else {
                this.readLock.unlock();
            }
        }

        @Override
        public void close() {
            this.unlock();
        }
    }
}

