/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.io;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IProgressMonitor;

public class ProgressTrackingInputStream
extends InputStream {
    private IProgressMonitor monitor;
    private InputStream delegate;

    public ProgressTrackingInputStream(InputStream delegate, IProgressMonitor monitor) {
        this.delegate = delegate;
        this.monitor = monitor;
    }

    private int log(int read) {
        if (read != -1) {
            this.monitor.worked(read);
        }
        return read;
    }

    @Override
    public int read() throws IOException {
        return this.log(this.delegate.read());
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.log(this.delegate.read(b));
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.log(this.delegate.read(b, off, len));
    }

    public boolean equals(Object obj) {
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.delegate.skip(n);
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public int available() throws IOException {
        return this.delegate.available();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }

    @Override
    public void mark(int readlimit) {
        this.delegate.mark(readlimit);
    }

    @Override
    public void reset() throws IOException {
        this.delegate.reset();
    }

    @Override
    public boolean markSupported() {
        return this.delegate.markSupported();
    }
}

