/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.extensionpoint.internal;

import java.util.Stack;
import org.mule.tooling.utils.extensionpoint.DefaultExtensionContext;
import org.mule.tooling.utils.extensionpoint.features.IExtensionReadingContext;

public class ObjectReadingContext<T>
implements IExtensionReadingContext<T> {
    protected final Class<T> baseType;
    protected final Stack<DefaultExtensionContext<T>> extensionContextsStack;
    protected final IExtensionReadingContext<?> parentContext;

    public ObjectReadingContext(Class<T> baseType, IExtensionReadingContext<?> parentContext) {
        this.baseType = baseType;
        this.parentContext = parentContext;
        this.extensionContextsStack = new Stack();
    }

    @Override
    public IExtensionReadingContext<?> getParentContext() {
        return this.parentContext;
    }

    public void popExtensionContext(DefaultExtensionContext<T> readExtensionContext) {
        DefaultExtensionContext<T> lastRootContext = null;
        if (!this.extensionContextsStack.isEmpty()) {
            lastRootContext = this.extensionContextsStack.pop();
        }
        if (lastRootContext == null || lastRootContext != readExtensionContext) {
            throw new IllegalStateException("finishing to read a context that was not the latest one in the stack");
        }
    }

    public void pushExtensionContext(DefaultExtensionContext<T> extensionContext) {
        this.extensionContextsStack.push(extensionContext);
    }

    @Override
    public DefaultExtensionContext<T> getCurrentExtensionContext() {
        return this.extensionContextsStack.peek();
    }

    @Override
    public Class<T> getBaseType() {
        return this.baseType;
    }
}

