/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.extensionpoint.internal;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;
import org.mule.tooling.utils.extensionpoint.features.ExtensionPointCollectorFeature;
import org.mule.tooling.utils.extensionpoint.features.IExtensionReadingContext;
import org.mule.tooling.utils.extensionpoint.features.ObjectReaderFeature;
import org.mule.tooling.utils.extensionpoint.internal.ObjectReadingContext;

public class ExtensionReadingContext<T>
extends ObjectReadingContext<T> {
    private final ExtensionPoint extensionPointAnnotation;
    private Iterator<IConfigurationElement> configurationElementsIterator;

    public ExtensionReadingContext(IExtensionReadingContext<?> parentContext, Class<T> baseType, ExtensionPoint extensionPointAnnotation) {
        super(baseType, parentContext);
        this.extensionPointAnnotation = extensionPointAnnotation;
    }

    public ExtensionPoint getExtensionPointAnnotation() {
        return this.extensionPointAnnotation;
    }

    Iterator<IConfigurationElement> getConfigurationElementsIterator() {
        if (this.configurationElementsIterator == null) {
            IConfigurationElement[] configurationElementsArray = Platform.getExtensionRegistry().getConfigurationElementsFor(this.extensionPointAnnotation.extensionPointId());
            List<IConfigurationElement> configurationElements = Arrays.asList(configurationElementsArray);
            this.configurationElementsIterator = configurationElements.iterator();
        }
        return this.configurationElementsIterator;
    }

    public List<ExtensionPointCollectorFeature> getCollectorFeatures() {
        return Arrays.stream(this.getExtensionPointAnnotation().collectorFeatures()).map(ObjectReaderFeature::instantiateType).collect(Collectors.toList());
    }
}

