/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.extensionpoint.internal;

import java.util.List;
import java.util.stream.Collectors;
import org.mule.tooling.utils.extensionpoint.DefaultExtensionContext;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;
import org.mule.tooling.utils.extensionpoint.IFaultReporter;
import org.mule.tooling.utils.extensionpoint.features.ExtensionPointCollectorFeature;
import org.mule.tooling.utils.extensionpoint.features.IExtensionReadingContext;
import org.mule.tooling.utils.extensionpoint.internal.ExtensionReadingContext;
import org.mule.tooling.utils.extensionpoint.internal.IExtensionObjectReader;

public class ExtensionPointReader<T>
implements IExtensionPointReader<T> {
    private final ExtensionReadingContext<T> readingContext;
    private final IExtensionObjectReader<T> extensionObjectReader;

    public ExtensionPointReader(Class<T> type, ExtensionPoint extensionPointAnnotation, IExtensionReadingContext<?> parentContext, IExtensionObjectReader<T> objectsReader) {
        this.readingContext = new ExtensionReadingContext<T>(parentContext, type, extensionPointAnnotation);
        this.extensionObjectReader = objectsReader;
    }

    @Override
    public List<T> readAll(IFaultReporter faultReporter) {
        List<DefaultExtensionContext<T>> rootContexts = this.extensionObjectReader.readExtensionObjects(this.readingContext, faultReporter);
        List<ExtensionPointCollectorFeature> extensionPointFeatures = this.readingContext.getCollectorFeatures();
        List transformed = rootContexts.stream().map(context -> context.getExtensionObject()).collect(Collectors.toList());
        for (ExtensionPointCollectorFeature feature : extensionPointFeatures) {
            transformed = feature.collect(transformed, this.readingContext, rootContexts);
        }
        return transformed;
    }
}

