/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.extensionpoint.internal;

import jakarta.inject.Inject;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.mule.tooling.utils.extensionpoint.DefaultExtensionContext;
import org.mule.tooling.utils.extensionpoint.ExtensionAttribute;
import org.mule.tooling.utils.extensionpoint.ExtensionChildElement;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;
import org.mule.tooling.utils.extensionpoint.IFaultReporter;
import org.mule.tooling.utils.extensionpoint.features.ObjectReaderFeature;
import org.mule.tooling.utils.extensionpoint.features.internal.Initialize;
import org.mule.tooling.utils.extensionpoint.features.internal.InjectBundle;
import org.mule.tooling.utils.extensionpoint.features.internal.JoinExtensionPoints;
import org.mule.tooling.utils.extensionpoint.features.internal.ReadAttributes;
import org.mule.tooling.utils.extensionpoint.features.internal.ReadCollections;
import org.mule.tooling.utils.extensionpoint.features.internal.ReadMaps;
import org.mule.tooling.utils.extensionpoint.internal.ExtensionReadingContext;
import org.mule.tooling.utils.extensionpoint.internal.IExtensionObjectReader;
import org.mule.tooling.utils.extensionpoint.internal.ObjectReadingContext;
import org.mule.tooling.utils.reflect.ReflectionUtils;
import org.osgi.framework.Bundle;

public class ExtensionObjectReader<T>
implements IExtensionObjectReader<T> {
    private static final ReadMaps READ_MAPS_FEATURE = new ReadMaps();
    private static final Initialize INITIALIZE_FEATURE = new Initialize();
    private static final InjectBundle INJECT_BUNDLE_FEATURE = new InjectBundle();
    private static final ReadCollections READ_COLLECTIONS = new ReadCollections();
    private static final ReadAttributes READ_ATTRIBUTES_FEATURE = new ReadAttributes();
    private static final JoinExtensionPoints JOIN_EXTENSION_POINTS = new JoinExtensionPoints();
    private final Class<T> baseType;
    private final List<ObjectReaderFeature> features;

    public ExtensionObjectReader(Class<T> baseType, List<ObjectReaderFeature> baseFeatures) {
        this.baseType = baseType;
        this.features = this.getFeatures(baseFeatures, baseType);
    }

    public ExtensionObjectReader(Class<T> baseType) {
        this(baseType, Collections.emptyList());
    }

    @Override
    public List<DefaultExtensionContext<T>> readExtensionObjects(ExtensionReadingContext<T> readingContext, IFaultReporter faultReporter) {
        ArrayList<DefaultExtensionContext<T>> rootContexts = new ArrayList<DefaultExtensionContext<T>>();
        while (readingContext.getConfigurationElementsIterator().hasNext()) {
            DefaultExtensionContext<T> rootContext = this.read(readingContext, faultReporter);
            if (rootContext == null) continue;
            rootContexts.add(rootContext);
        }
        return rootContexts;
    }

    private DefaultExtensionContext<T> read(ExtensionReadingContext<T> readingContext, IFaultReporter faultReporter) {
        DefaultExtensionContext<T> result = null;
        Iterator<IConfigurationElement> iterator = readingContext.getConfigurationElementsIterator();
        ExtensionPoint extensionPointAnnotation = readingContext.getExtensionPointAnnotation();
        String elementName = extensionPointAnnotation.elementName();
        while (iterator.hasNext() && result == null) {
            IConfigurationElement configurationElement = iterator.next();
            if (!StringUtils.isBlank((String)elementName) && !elementName.equals(configurationElement.getName())) continue;
            result = this.readObject(readingContext, configurationElement, faultReporter);
        }
        return result;
    }

    @Override
    public DefaultExtensionContext<T> readObject(ObjectReadingContext<T> readingContext, IConfigurationElement configurationElement, IFaultReporter faultReporter) {
        T extensionObject = ObjectReaderFeature.instantiateType(this.baseType);
        DefaultExtensionContext<T> extensionContext = DefaultExtensionContext.create(configurationElement, extensionObject, this.baseType);
        readingContext.pushExtensionContext(extensionContext);
        for (ObjectReaderFeature feature : this.features) {
            feature.readObject(readingContext, faultReporter);
        }
        readingContext.popExtensionContext(extensionContext);
        return extensionContext;
    }

    private List<ObjectReaderFeature> getFeatures(List<ObjectReaderFeature> baseFeatures, Class<?> type) {
        ArrayList<ObjectReaderFeature> features = new ArrayList<ObjectReaderFeature>();
        if (this.hasAnnotatedFieldsOfType(type, Inject.class, Bundle.class)) {
            features.add(INJECT_BUNDLE_FEATURE);
        }
        if (this.hasAnnotatedFieldsOfType(type, ExtensionAttribute.class, Object.class)) {
            features.add(READ_ATTRIBUTES_FEATURE);
        }
        if (this.hasAnnotatedFieldsOfType(type, ExtensionChildElement.class, Map.class)) {
            features.add(READ_MAPS_FEATURE);
        }
        if (this.hasAnnotatedFieldsOfType(type, ExtensionChildElement.class, Collection.class)) {
            features.add(READ_COLLECTIONS);
        }
        if (this.hasAnnotatedFieldsOfType(type, ExtensionPoint.class, Collection.class)) {
            features.add(JOIN_EXTENSION_POINTS);
        }
        baseFeatures.stream().filter(feature -> !features.contains(feature)).forEach(features::add);
        features.add(INITIALIZE_FEATURE);
        return features;
    }

    private boolean hasAnnotatedFieldsOfType(Class<?> type, Class<? extends Annotation> annotation, Class<?> fieldType) {
        List<Field> annotatedFields = ReflectionUtils.getAnnotatedFields(type, annotation);
        return annotatedFields.stream().anyMatch(field -> fieldType.isAssignableFrom(field.getType()));
    }
}

