/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.extensionpoint.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;
import org.mule.tooling.utils.extensionpoint.features.IExtensionReadingContext;
import org.mule.tooling.utils.extensionpoint.features.ObjectReaderFeature;
import org.mule.tooling.utils.extensionpoint.internal.CachingObjectsReader;
import org.mule.tooling.utils.extensionpoint.internal.ExtensionObjectReader;
import org.mule.tooling.utils.extensionpoint.internal.ExtensionPointReader;
import org.mule.tooling.utils.extensionpoint.internal.IExtensionObjectReader;
import org.mule.tooling.utils.extensionpoint.internal.IExtensionPointReaderFactory;

public class CachingExtensionPointReaderFactory
implements IExtensionPointReaderFactory {
    private final Map<ObjectReaderRegistryKey, IExtensionObjectReader<?>> readersRegistry = new ConcurrentHashMap();

    @Override
    public <T> IExtensionPointReader<T> create(Class<T> type, ExtensionPoint extensionPointAnnotation, IExtensionReadingContext<?> context) {
        IExtensionObjectReader<T> objectsReader = extensionPointAnnotation.cacheable() ? this.getResultCachingReader(type, extensionPointAnnotation, context) : this.createDefaultObjectsReader(type, extensionPointAnnotation);
        return new ExtensionPointReader<T>(type, extensionPointAnnotation, context, objectsReader);
    }

    protected <T> IExtensionObjectReader<T> createDefaultObjectsReader(Class<T> type, ExtensionPoint extensionPointAnnotation) {
        return new ExtensionObjectReader<T>(type, this.getReaderFeatures(extensionPointAnnotation));
    }

    private List<ObjectReaderFeature> getReaderFeatures(ExtensionPoint extensionPointAnnotation) {
        return Arrays.stream(extensionPointAnnotation.readerFeatures()).map(ObjectReaderFeature::instantiateType).collect(Collectors.toList());
    }

    private <T> IExtensionObjectReader<T> getResultCachingReader(Class<T> type, ExtensionPoint extensionPointAnnotation, IExtensionReadingContext<?> context) {
        return this.readersRegistry.computeIfAbsent(ObjectReaderRegistryKey.create(type, extensionPointAnnotation), key -> new CachingObjectsReader(this.createDefaultObjectsReader(type, extensionPointAnnotation)));
    }

    private static class ObjectReaderRegistryKey {
        private final Class<?> type;
        private final String elementName;
        private final String extensionPointId;
        private final Collection<Class<? extends ObjectReaderFeature>> features;

        private static ObjectReaderRegistryKey create(Class<?> type, ExtensionPoint annotation) {
            return new ObjectReaderRegistryKey(type, annotation.elementName(), annotation.extensionPointId(), Arrays.asList(annotation.readerFeatures()));
        }

        private ObjectReaderRegistryKey(Class<?> type, String elementName, String extensionPointId, Collection<Class<? extends ObjectReaderFeature>> features) {
            this.type = type;
            this.elementName = elementName;
            this.extensionPointId = extensionPointId;
            this.features = features;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.elementName == null ? 0 : this.elementName.hashCode());
            result = 31 * result + (this.extensionPointId == null ? 0 : this.extensionPointId.hashCode());
            result = 31 * result + (this.features == null ? 0 : this.features.hashCode());
            result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ObjectReaderRegistryKey other = (ObjectReaderRegistryKey)obj;
            if (this.elementName == null ? other.elementName != null : !this.elementName.equals(other.elementName)) {
                return false;
            }
            if (this.extensionPointId == null ? other.extensionPointId != null : !this.extensionPointId.equals(other.extensionPointId)) {
                return false;
            }
            if (this.features == null ? other.features != null : !this.features.equals(other.features)) {
                return false;
            }
            return !(this.type == null ? other.type != null : !this.type.equals(other.type));
        }
    }
}

