/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.extensionpoint.features.internal;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.mule.tooling.utils.extensionpoint.DefaultExtensionContext;
import org.mule.tooling.utils.extensionpoint.ExtensionChildElement;
import org.mule.tooling.utils.extensionpoint.IFaultReporter;
import org.mule.tooling.utils.extensionpoint.features.ObjectReaderFeature;
import org.mule.tooling.utils.reflect.ReflectionUtils;

public class ReadMaps
implements ObjectReaderFeature {
    private static final String VALUE_DEFAULT_KEY = "value";

    @Override
    public void readObject(DefaultExtensionContext<?> context, IFaultReporter faultReporter) {
        List<Field> annotatedFields = ReflectionUtils.getAnnotatedFields(context.getType(), ExtensionChildElement.class);
        for (Field field : annotatedFields) {
            ExtensionChildElement annotation = field.getAnnotation(ExtensionChildElement.class);
            if (!Map.class.isAssignableFrom(field.getType())) continue;
            this.populateMapField(context, field, annotation, faultReporter);
        }
    }

    private void populateMapField(DefaultExtensionContext<?> context, Field field, ExtensionChildElement annotation, IFaultReporter faultReporter) {
        IConfigurationElement configurationElement = context.getElement();
        HashMap<String, Object> childElementsMap = new HashMap<String, Object>();
        if (!annotation.wrapperElementName().isEmpty()) {
            IConfigurationElement[] children = configurationElement.getChildren(annotation.wrapperElementName());
            if (children.length == 0 && !annotation.optional()) {
                faultReporter.requiredChildElementMissing(annotation.wrapperElementName());
            } else if (children.length == 1) {
                IConfigurationElement wrapperElement = children[0];
                this.collectChildElementEntries(wrapperElement, annotation, childElementsMap, faultReporter);
            }
        } else {
            this.collectChildElementEntries(configurationElement, annotation, childElementsMap, faultReporter);
        }
        this.setFieldObject(context.getExtensionObject(), field, childElementsMap);
    }

    private void collectChildElementEntries(IConfigurationElement configurationElement, ExtensionChildElement annotation, Map<String, Object> childElementsMap, IFaultReporter faultReporter) {
        String childElementsName = annotation.childElementsName();
        IConfigurationElement[] children = configurationElement.getChildren(childElementsName);
        if (children.length == 0 && !annotation.optional()) {
            faultReporter.requiredChildElementMissing(childElementsName);
        }
        IConfigurationElement[] iConfigurationElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object readValue;
            IConfigurationElement child = iConfigurationElementArray[n2];
            String attributeName = annotation.attributeName();
            String keyAttribute = child.getAttribute("key");
            if (keyAttribute == null) {
                faultReporter.requiredAttributeMissing("key attribute in child element " + child.getName());
            }
            if (attributeName.isEmpty()) {
                attributeName = VALUE_DEFAULT_KEY;
            }
            if (!annotation.elementType().equals(String.class)) {
                readValue = this.createExecutableExtension(child, attributeName, faultReporter);
            } else {
                String attribute = child.getAttribute(attributeName);
                readValue = this.transformToFieldType(attribute, annotation.elementType(), faultReporter);
            }
            childElementsMap.put(keyAttribute, readValue);
            ++n2;
        }
    }
}

