/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.extensionpoint.features.internal;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.mule.tooling.utils.extensionpoint.DefaultExtensionContext;
import org.mule.tooling.utils.extensionpoint.ExtensionChildElement;
import org.mule.tooling.utils.extensionpoint.IFaultReporter;
import org.mule.tooling.utils.extensionpoint.features.IExtensionReadingContext;
import org.mule.tooling.utils.extensionpoint.features.ObjectReaderFeature;
import org.mule.tooling.utils.extensionpoint.internal.ExtensionObjectReader;
import org.mule.tooling.utils.extensionpoint.internal.ObjectReadingContext;
import org.mule.tooling.utils.reflect.ReflectionUtils;

public class ReadCollections
implements ObjectReaderFeature {
    @Override
    public void readObject(IExtensionReadingContext<?> context, IFaultReporter faultReporter) {
        DefaultExtensionContext<?> currentExtensionContext = context.getCurrentExtensionContext();
        List<Field> annotatedFields = ReflectionUtils.getAnnotatedFields(currentExtensionContext.getType(), ExtensionChildElement.class);
        for (Field field : annotatedFields) {
            ExtensionChildElement annotation = field.getAnnotation(ExtensionChildElement.class);
            if (!Collection.class.isAssignableFrom(field.getType())) continue;
            this.populateCollectionField(context, field, annotation, faultReporter);
        }
    }

    private void populateCollectionField(IExtensionReadingContext<?> context, Field field, ExtensionChildElement annotation, IFaultReporter faultReporter) {
        List<Object> childElements = new ArrayList();
        DefaultExtensionContext<?> currentContext = context.getCurrentExtensionContext();
        IConfigurationElement element = currentContext.getElement();
        if (!annotation.wrapperElementName().isEmpty()) {
            IConfigurationElement[] children = element.getChildren(annotation.wrapperElementName());
            if (children.length == 0 && !annotation.optional()) {
                faultReporter.requiredChildElementMissing(annotation.wrapperElementName());
            } else if (children.length == 1) {
                IConfigurationElement wrapperElement = children[0];
                childElements = this.collectChildElements(context, wrapperElement, annotation, faultReporter);
            }
        } else {
            childElements = this.collectChildElements(context, element, annotation, faultReporter);
        }
        this.setFieldObject(currentContext.getExtensionObject(), field, childElements);
    }

    private List<?> collectChildElements(IExtensionReadingContext<?> parentContext, IConfigurationElement configurationElement, ExtensionChildElement annotation, IFaultReporter faultReporter) {
        String childElementsName = annotation.childElementsName();
        IConfigurationElement[] children = configurationElement.getChildren(childElementsName);
        if (children.length == 0 && !annotation.optional()) {
            faultReporter.requiredChildElementMissing(childElementsName);
        }
        Class<?> childType = annotation.elementType();
        String attributeName = annotation.attributeName();
        return this.readChildren(children, childType, attributeName, parentContext, faultReporter);
    }

    private <T> List<T> readChildren(IConfigurationElement[] children, Class<T> childType, String attributeName, IExtensionReadingContext<?> parentContext, IFaultReporter faultReporter) {
        ArrayList<T> readChildren = new ArrayList<T>(children.length);
        ExtensionObjectReader<T> extensionObjectReader = new ExtensionObjectReader<T>(childType);
        ObjectReadingContext<T> childrenReadingContext = new ObjectReadingContext<T>(childType, parentContext);
        IConfigurationElement[] iConfigurationElementArray = children;
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Object readChild;
            IConfigurationElement child = iConfigurationElementArray[n2];
            if (attributeName.isEmpty()) {
                DefaultExtensionContext<T> readContext = extensionObjectReader.readObject(childrenReadingContext, child, faultReporter);
                readChild = readContext.getExtensionObject();
            } else if (!attributeName.isEmpty() && !childType.equals(String.class)) {
                readChild = childType.isInterface() || ReflectionUtils.isAbstractClass(childType) || ReflectionUtils.hasEmptyConstructor(childType) ? this.createExecutableExtension(child, attributeName, faultReporter) : this.transformToFieldType(child.getAttribute(attributeName), childType, faultReporter);
            } else {
                String attribute = child.getAttribute(attributeName);
                readChild = this.transformToFieldType(attribute, childType, faultReporter);
            }
            readChildren.add(readChild);
            ++n2;
        }
        return readChildren;
    }
}

