/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.extensionpoint.features.internal;

import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.ClassUtils;
import org.eclipse.core.runtime.IConfigurationElement;
import org.mule.tooling.utils.extensionpoint.DefaultExtensionContext;
import org.mule.tooling.utils.extensionpoint.ExtensionAttribute;
import org.mule.tooling.utils.extensionpoint.IFaultReporter;
import org.mule.tooling.utils.extensionpoint.features.ObjectReaderFeature;
import org.mule.tooling.utils.reflect.ReflectionUtils;

public class ReadAttributes
implements ObjectReaderFeature {
    private static final Collection<Class<? extends Object>> BASIC_TYPES = Arrays.asList(String.class, Boolean.class, Integer.class, Short.class, Long.class, Double.class, Float.class, Byte.class, Character.class);

    @Override
    public void readObject(DefaultExtensionContext<?> context, IFaultReporter faultReporter) {
        List<Field> annotatedFields = ReflectionUtils.getAnnotatedFields(context.getType(), ExtensionAttribute.class);
        for (Field field : annotatedFields) {
            ExtensionAttribute annotation = field.getAnnotation(ExtensionAttribute.class);
            if (annotation == null) continue;
            this.populateAttributeField(context, field, annotation, faultReporter);
        }
    }

    private void populateAttributeField(DefaultExtensionContext<?> currentContext, Field field, ExtensionAttribute annotation, IFaultReporter faultReporter) {
        String attributeName = annotation.attributeName().isEmpty() ? field.getName() : annotation.attributeName();
        IConfigurationElement element = currentContext.getElement();
        String attribute = element.getAttribute(attributeName);
        if (attribute == null && !annotation.optional()) {
            faultReporter.requiredAttributeMissing(attributeName);
        } else if (attribute != null) {
            Object extensionObject = currentContext.getExtensionObject();
            if (field.getType().isEnum()) {
                Object attributeValue = this.transformToFieldType(attribute, field.getType(), faultReporter);
                this.setFieldObject(extensionObject, field, attributeValue);
            } else if (!this.isBasicType(field.getType())) {
                Object attributeValue = field.getType().isInterface() || ReflectionUtils.isAbstractClass(field.getType()) ? this.createExecutableExtension(element, attributeName, faultReporter) : this.transformToFieldType(element.getAttribute(attributeName), field.getType(), faultReporter);
                if (attributeValue != null) {
                    this.setFieldObject(extensionObject, field, attributeValue);
                }
            } else {
                Object attributeValue = this.transformToFieldType(attribute, field.getType(), faultReporter);
                this.setFieldObject(extensionObject, field, attributeValue);
            }
        }
    }

    private boolean isBasicType(Class<?> type) {
        Class _type = type.isPrimitive() ? ClassUtils.primitiveToWrapper(type) : type;
        return BASIC_TYPES.contains(_type);
    }
}

