/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.extensionpoint.features.internal;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import org.mule.tooling.utils.UtilsPlugin;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;
import org.mule.tooling.utils.extensionpoint.IExtensionPointReader;
import org.mule.tooling.utils.extensionpoint.IFaultReporter;
import org.mule.tooling.utils.extensionpoint.features.IExtensionReadingContext;
import org.mule.tooling.utils.extensionpoint.features.ObjectReaderFeature;
import org.mule.tooling.utils.reflect.ReflectionUtils;

public class JoinExtensionPoints
implements ObjectReaderFeature {
    private static final Class<ExtensionPoint> EXTENSION_POINT = ExtensionPoint.class;

    @Override
    public void readObject(IExtensionReadingContext<?> context, IFaultReporter faultReporter) {
        Class<?> type = context.getCurrentExtensionContext().getType();
        List<Field> extensionPointFields = ReflectionUtils.getAnnotatedFields(type, EXTENSION_POINT);
        for (Field field : extensionPointFields) {
            if (Collection.class.isAssignableFrom(field.getType())) {
                ExtensionPoint extensionPoint = field.getAnnotation(EXTENSION_POINT);
                Class<?> extensionPointType = extensionPoint.type();
                if (!Void.class.equals(extensionPointType)) {
                    IExtensionPointReader<?> reader = UtilsPlugin.getExtensionPointReaderFactory().create(extensionPointType, extensionPoint, context);
                    List<?> innerExtensionPointObjects = reader.readAll(faultReporter);
                    this.setFieldObject(context.getCurrentExtensionContext().getExtensionObject(), field, innerExtensionPointObjects);
                    continue;
                }
                throw new IllegalArgumentException("when joining extension points, the type attribute in the annotation is mandatory");
            }
            throw new IllegalArgumentException("fields annotated with " + EXTENSION_POINT.getName() + " must be of a " + Collection.class.getName() + " type to hold multiple results");
        }
    }
}

