/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.extensionpoint.features;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.commons.lang.ClassUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.mule.tooling.utils.extensionpoint.DefaultExtensionContext;
import org.mule.tooling.utils.extensionpoint.IFaultReporter;
import org.mule.tooling.utils.extensionpoint.features.IExtensionReadingContext;
import org.mule.tooling.utils.reflect.ReflectionUtils;

public interface ObjectReaderFeature {
    public static final String VALUE_OF = "valueOf";

    default public void readObject(IExtensionReadingContext<?> readingContext, IFaultReporter faultReporter) {
        this.readObject(readingContext.getCurrentExtensionContext(), faultReporter);
    }

    default public void readObject(DefaultExtensionContext<?> currentExtensionContext, IFaultReporter faultReporter) {
    }

    default public void setFieldObject(Object extensionObject, Field field, Object value) {
        ReflectionUtils.invokeSetter(field.getName(), field.getType(), value, extensionObject);
    }

    default public <T> T transformToFieldType(String attribute, Class<T> fieldType, IFaultReporter faultReporter) {
        Object attributeValue;
        try {
            if (fieldType.isPrimitive()) {
                Class wrapperType = ClassUtils.primitiveToWrapper(fieldType);
                Method valueOfMethod = wrapperType.getDeclaredMethod(VALUE_OF, String.class);
                attributeValue = valueOfMethod.invoke(null, attribute);
            } else if (fieldType.equals(String.class)) {
                attributeValue = String.valueOf(attribute);
            } else {
                Method valueOfMethod = fieldType.getDeclaredMethod(VALUE_OF, String.class);
                attributeValue = valueOfMethod.invoke(null, attribute);
            }
        }
        catch (SecurityException e) {
            faultReporter.handleExceptionCreatingObject(e);
            return null;
        }
        catch (NoSuchMethodException e) {
            faultReporter.handleExceptionCreatingObject(e);
            return null;
        }
        catch (IllegalArgumentException e) {
            faultReporter.handleExceptionCreatingObject(e);
            return null;
        }
        catch (IllegalAccessException e) {
            faultReporter.handleExceptionCreatingObject(e);
            return null;
        }
        catch (InvocationTargetException e) {
            faultReporter.handleExceptionCreatingObject(e);
            return null;
        }
        return (T)attributeValue;
    }

    default public Object createExecutableExtension(IConfigurationElement configurationElement, String attributeName, IFaultReporter faultReporter) {
        try {
            return configurationElement.createExecutableExtension(attributeName);
        }
        catch (CoreException e) {
            faultReporter.handleExceptionCreatingObject(e);
            return null;
        }
    }

    public static <T> T instantiateType(Class<T> type) {
        try {
            return type.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException(e);
        }
    }
}

