/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.extensionpoint;

import java.util.List;
import org.mule.tooling.utils.UtilsPlugin;
import org.mule.tooling.utils.extensionpoint.ExtensionPoint;
import org.mule.tooling.utils.extensionpoint.FaultReporterAdapter;
import org.mule.tooling.utils.extensionpoint.IFaultReporter;
import org.mule.tooling.utils.extensionpoint.internal.IExtensionPointReaderFactory;

public interface IExtensionPointReader<T> {
    public static final IFaultReporter DEFAULT_FAULT_REPORTER = new FaultReporterAdapter();

    default public List<T> readAll() {
        return this.readAll(DEFAULT_FAULT_REPORTER);
    }

    public List<T> readAll(IFaultReporter var1);

    public static <T> IExtensionPointReader<T> create(Class<T> type) {
        ExtensionPoint extensionPointAnnotation = type.getAnnotation(ExtensionPoint.class);
        if (extensionPointAnnotation == null) {
            throw new IllegalArgumentException("The type parameter must be annotated with the " + ExtensionPoint.class.getName() + " annotation");
        }
        IExtensionPointReaderFactory factory = UtilsPlugin.getExtensionPointReaderFactory();
        return factory.create(type, extensionPointAnnotation, null);
    }
}

