/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.extensionpoint;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.mule.tooling.utils.UtilsPlugin;
import org.mule.tooling.utils.extensionpoint.IFaultReporter;

public class FaultReporterAdapter
implements IFaultReporter {
    protected void handleGeneralFault(String description) {
        UtilsPlugin.debugTracer().trace("/debug/fault-reporter", "[extension-point] " + description);
    }

    protected void handleGenericException(Throwable e) {
        UtilsPlugin.logError(MessageFormat.format("Exception creating object {0} message: {1}", e.getClass().getName(), e.getMessage()), e);
    }

    @Override
    public void optionalAttributeMissing(String attribute) {
        this.handleGeneralFault("Missing optional attribute " + attribute);
    }

    @Override
    public void requiredAttributeMissing(String attribute) {
        this.handleGeneralFault("Missing required attribute " + attribute);
    }

    @Override
    public void requiredChildElementMissing(String elementName) {
        this.handleGeneralFault("Missing child element " + elementName);
    }

    @Override
    public void handleExceptionCreatingObject(CoreException e) {
        this.handleGenericException((Throwable)e);
    }

    @Override
    public void handleExceptionCreatingObject(SecurityException e) {
        this.handleGenericException(e);
    }

    @Override
    public void handleExceptionCreatingObject(NoSuchMethodException e) {
        this.handleGenericException(e);
    }

    @Override
    public void handleExceptionCreatingObject(IllegalArgumentException e) {
        this.handleGenericException(e);
    }

    @Override
    public void handleExceptionCreatingObject(IllegalAccessException e) {
        this.handleGenericException(e);
    }

    @Override
    public void handleExceptionCreatingObject(InvocationTargetException e) {
        this.handleGenericException(e);
    }
}

