/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.extensionpoint;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Platform;
import org.mule.tooling.utils.extensionpoint.ExtensionContext;
import org.osgi.framework.Bundle;

public class DefaultExtensionContext<T>
implements ExtensionContext {
    private final Bundle bundle;
    private final File bundleRootFile;
    private final IConfigurationElement configurationElement;
    private final T extensionObject;
    private final Class<T> type;

    public static <P> DefaultExtensionContext<P> create(IConfigurationElement element, P extensionObject, Class<P> type) {
        DefaultExtensionContext<P> extensionContext = null;
        try {
            extensionContext = new DefaultExtensionContext<P>(element, extensionObject, type);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return extensionContext;
    }

    private static Bundle getBundle(IConfigurationElement element) {
        String plugin = element.getContributor().getName();
        try {
            return Platform.getBundle((String)plugin);
        }
        catch (InvalidRegistryObjectException e) {
            throw new IllegalStateException(e);
        }
    }

    private DefaultExtensionContext(IConfigurationElement element, T extensionObject, Class<T> type) throws IOException {
        this.configurationElement = element;
        this.extensionObject = extensionObject;
        this.bundle = DefaultExtensionContext.getBundle(this.configurationElement);
        this.bundleRootFile = FileLocator.getBundleFile((Bundle)this.bundle);
        this.type = type;
    }

    @Override
    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    public File getBundleRoot() {
        return this.bundleRootFile;
    }

    public IConfigurationElement getElement() {
        return this.configurationElement;
    }

    public T getExtensionObject() {
        return this.extensionObject;
    }

    public Class<T> getType() {
        return this.type;
    }
}

