/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.eventbus;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Widget;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventRegistrationHandler;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class EventBusHelper {
    private List<EventRegistrationHandler> handlers = new ArrayList<EventRegistrationHandler>();

    public <T extends IEventHandler> void registerListener(EventBus bus, EventType<T> type, T listener) {
        this.addHandler(bus.registerListener(type, listener));
    }

    public <T extends IEventHandler> void registerListener(EventBus bus, EventType<T> type, T listener, int priority) {
        this.addHandler(bus.registerListener(type, listener, priority));
    }

    public <T extends IEventHandler> void registerUIListener(EventBus bus, EventType<T> type, T listener) {
        this.addHandler(bus.registerUIThreadListener(type, listener));
    }

    public <T extends IEventHandler> void registerUIListener(EventBus bus, EventType<T> type, T listener, int priority) {
        this.addHandler(bus.registerUIThreadListener(type, listener, priority));
    }

    public void unregister() {
        List<EventRegistrationHandler> oldHandlers = this.handlers;
        this.handlers = new ArrayList<EventRegistrationHandler>();
        for (EventRegistrationHandler handler : oldHandlers) {
            handler.unregister();
        }
    }

    public void unregisterWith(final Widget scrolledComposite) {
        scrolledComposite.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                EventBusHelper.this.unregister();
                scrolledComposite.removeDisposeListener((DisposeListener)this);
            }
        });
    }

    private void addHandler(EventRegistrationHandler handler) {
        this.handlers.add(handler);
    }

    public void addAllHandler(List<EventRegistrationHandler> handler) {
        this.handlers.addAll(handler);
    }
}

