/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils.eventbus;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.mule.tooling.utils.SilentRunner;
import org.mule.tooling.utils.UtilsPlugin;
import org.mule.tooling.utils.eventbus.EventRegistrationHandler;
import org.mule.tooling.utils.eventbus.EventType;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.eventbus.IEventBus;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class EventBus
implements IEventBus {
    private static final String ATTRIBUTE_EVENT_ID = "eventId";
    private static final String ATTRIBUTE_HANDLER_CLASS = "handlerClass";
    private Map<EventType<?>, List<EventHandlerHolder>> listeners = new ConcurrentHashMap();
    private static AtomicBoolean extensionPointListenersInitialized = new AtomicBoolean(false);
    private ThreadLocal<Queue<IEvent<?>>> eventsQueue = new ThreadLocal();
    private boolean runInUIThread = false;

    public EventBus(String extensionPointId) {
        if (extensionPointId != null) {
            this.loadExtensionPointListeners(extensionPointId);
        }
    }

    public EventBus() {
        this(null);
    }

    public EventBus(boolean runInUIThread) {
        this(null);
        this.runInUIThread = runInUIThread;
    }

    private void loadExtensionPointListeners(String extensionPointId) {
        if (extensionPointListenersInitialized.compareAndSet(false, true)) {
            IConfigurationElement[] configurationElements;
            IConfigurationElement[] iConfigurationElementArray = configurationElements = Platform.getExtensionRegistry().getConfigurationElementsFor(extensionPointId);
            int n = configurationElements.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement configurationElement = iConfigurationElementArray[n2];
                this.registerExtensionPointListener(configurationElement);
                ++n2;
            }
        }
    }

    private void registerExtensionPointListener(IConfigurationElement configurationElement) {
        String eventId = configurationElement.getAttribute(ATTRIBUTE_EVENT_ID);
        if (eventId != null) {
            EventType eventType = EventType.id(eventId);
            try {
                IEventHandler handler = (IEventHandler)IEventHandler.class.cast(configurationElement.createExecutableExtension(ATTRIBUTE_HANDLER_CLASS));
                this.registerListener(eventType, handler);
            }
            catch (CoreException e) {
                UtilsPlugin.logWarning("Error registering event listener for " + String.valueOf(eventType), e);
            }
        } else {
            UtilsPlugin.logWarning("Error registering event listener, null event id", null);
        }
    }

    public <T extends IEventHandler> EventRegistrationHandler registerListener(EventType<T> type, T listener) {
        return this.registerListener(type, listener, 0);
    }

    public <T extends IEventHandler> EventRegistrationHandler registerUIThreadListener(EventType<T> type, T listener) {
        EventHandlerHolder eventHolder = new EventHandlerHolder(listener, 0, true);
        return this.register(type, eventHolder);
    }

    public <T extends IEventHandler> EventRegistrationHandler registerUIThreadListener(EventType<T> type, T listener, int priority) {
        EventHandlerHolder eventHolder = new EventHandlerHolder(listener, priority, true);
        return this.register(type, eventHolder);
    }

    public <T extends IEventHandler> EventRegistrationHandler registerListener(EventType<T> type, T listener, int priority) {
        EventHandlerHolder eventHolder = new EventHandlerHolder(listener, priority, false);
        return this.register(type, eventHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends IEventHandler> EventRegistrationHandler register(EventType<T> type, EventHandlerHolder eventHolder) {
        List eventHandlerHolders = this.listeners.computeIfAbsent(type, eventType -> new ArrayList());
        EventType<T> eventType2 = type;
        synchronized (eventType2) {
            eventHandlerHolders.add(eventHolder);
            Collections.sort(eventHandlerHolders);
        }
        return new EventRegistrationHandler(this, eventHolder, type);
    }

    private <T extends IEventHandler> List<EventHandlerHolder> getListeners(EventType<T> type) {
        return this.listeners.get(type);
    }

    public <T extends IEventHandler> void unRegisterListener(EventType<T> type, T listener) {
        EventHandlerHolder eventHolder = new EventHandlerHolder(listener, 0, false);
        this.unRegister(type, eventHolder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected <T extends IEventHandler> void unRegister(EventType<T> type, EventHandlerHolder eventHolder) {
        List<EventHandlerHolder> handlers = this.listeners.get(type);
        if (handlers != null) {
            EventType<T> eventType = type;
            synchronized (eventType) {
                handlers.remove(eventHolder);
            }
        }
    }

    @Override
    public <T extends IEventHandler> void fireEvent(IEvent<T> event) {
        if (this.getStack().isEmpty()) {
            this.getStack().add(event);
            this.doFireEvent();
        } else {
            this.getStack().add(event);
        }
    }

    private <T extends IEventHandler> void doFireEvent() {
        do {
            EventHandlerHolder[] handlerHolders;
            IEvent<?> event;
            EventType<?> associatedType;
            List<EventHandlerHolder> handlers;
            if ((handlers = this.getListeners(associatedType = (event = this.getStack().poll()).getAssociatedType())) == null) continue;
            EventHandlerHolder[] eventHandlerHolderArray = handlerHolders = handlers.toArray(new EventHandlerHolder[handlers.size()]);
            int n = handlerHolders.length;
            int n2 = 0;
            while (n2 < n) {
                final EventHandlerHolder handlerHolder = eventHandlerHolderArray[n2];
                SilentRunner.run(new Callable<Void>(){

                    @Override
                    public Void call() throws Exception {
                        if (EventBus.this.needsToRunInUIThread(handlerHolder)) {
                            if (Display.getCurrent() != null) {
                                event.dispatch(handlerHolder.getHandler());
                            } else {
                                EventBus.runUI(() -> event.dispatch(handlerHolder.getHandler()));
                            }
                        } else {
                            event.dispatch(handlerHolder.getHandler());
                        }
                        return null;
                    }
                }, null);
                ++n2;
            }
        } while (!this.getStack().isEmpty());
    }

    private static void runUI(Runnable task) {
        if (PlatformUI.isWorkbenchRunning()) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(task);
        }
    }

    public void cleanAllListeners() {
        this.listeners.clear();
    }

    private Queue<IEvent<?>> getStack() {
        Queue<IEvent<?>> queue = this.eventsQueue.get();
        if (queue == null) {
            queue = new LinkedList();
            this.eventsQueue.set(queue);
        }
        return queue;
    }

    protected boolean needsToRunInUIThread(EventHandlerHolder handlerHolder) {
        return handlerHolder.isUiThread() || this.runInUIThread;
    }

    static class EventHandlerHolder
    implements Comparable<EventHandlerHolder> {
        private IEventHandler handler;
        private Integer priority;
        private boolean uiThread;

        public EventHandlerHolder(IEventHandler handler, Integer priority, boolean uiThread) {
            this.handler = handler;
            this.priority = priority;
            this.uiThread = uiThread;
        }

        public Integer getPriority() {
            return this.priority;
        }

        public IEventHandler getHandler() {
            return this.handler;
        }

        public boolean isUiThread() {
            return this.uiThread;
        }

        @Override
        public int compareTo(EventHandlerHolder o) {
            return this.priority.compareTo(o.priority);
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.handler == null ? 0 : this.handler.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof EventHandlerHolder)) {
                return false;
            }
            EventHandlerHolder other = (EventHandlerHolder)obj;
            return !(this.handler == null ? other.handler != null : !this.handler.equals(other.handler));
        }
    }
}

