/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils;

import java.util.Dictionary;
import java.util.Hashtable;
import javax.tools.JavaCompiler;
import javax.tools.ToolProvider;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.osgi.service.debug.DebugTrace;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.mule.tooling.utils.LoggingStatus;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.extensionpoint.internal.CachingExtensionPointReaderFactory;
import org.mule.tooling.utils.extensionpoint.internal.IExtensionPointReaderFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;

public class UtilsPlugin
extends AbstractUIPlugin {
    public static final String CORE_EVENTS_EXTENSION_POINT_ID = "org.mule.tooling.utils.events";
    public static final String PLUGIN_ID = "org.mule.tooling.utils";
    public static final String DEBUG = "/debug";
    public static final String FAULT_REPORTER_ID = "/debug/fault-reporter";
    private static BundleContext context;
    private static UtilsPlugin instance;
    private volatile EventBus eventBus;
    private IEclipseContext eclipseContext;
    private static final Object lock;
    private ServiceRegistration<DebugOptionsListener> debugRegistration;
    private DebugTrace tracer;

    static {
        lock = new Object();
    }

    public static BundleContext getContext() {
        return context;
    }

    public void start(BundleContext bundleContext) throws Exception {
        context = bundleContext;
        this.registerDebugOptionsListener(context);
        this.eclipseContext = EclipseContextFactory.createServiceContext((BundleContext)bundleContext);
        this.eclipseContext.set(IExtensionPointReaderFactory.class, (Object)new CachingExtensionPointReaderFactory());
        instance = this;
    }

    public void stop(BundleContext bundleContext) throws Exception {
        this.unregisterDebugOptionsListener();
        instance = null;
        context = null;
    }

    public IEclipseContext getEclipseContext() {
        return this.eclipseContext;
    }

    public static UtilsPlugin getInstance() {
        return instance;
    }

    public static void logError(String message, Throwable t) {
        UtilsPlugin instance = UtilsPlugin.getInstance();
        if (instance != null) {
            ILog logger = instance.getLog();
            if (logger != null) {
                logger.log(UtilsPlugin.createStatus(4, message, t));
            } else {
                UtilsPlugin.fallbackLog(message, t);
            }
        } else {
            UtilsPlugin.fallbackLog(message, t);
        }
    }

    public static void logWarning(String message, Throwable t) {
        UtilsPlugin instance = UtilsPlugin.getInstance();
        if (instance != null) {
            ILog logger = instance.getLog();
            if (logger != null) {
                logger.log(UtilsPlugin.createStatus(2, message, t));
            } else {
                UtilsPlugin.fallbackLog(message, t);
            }
        } else {
            UtilsPlugin.fallbackLog(message, t);
        }
    }

    public static EventBus getEventBus() {
        if (UtilsPlugin.getInstance() == null) {
            return null;
        }
        return UtilsPlugin.getInstance().eventBus();
    }

    public IProvisioningAgent getProvisioningAgent() {
        return (IProvisioningAgent)this.getService(IProvisioningAgent.SERVICE_NAME);
    }

    public Object getService(String name) {
        BundleContext context = this.getBundle().getBundleContext();
        ServiceReference reference = context.getServiceReference(name);
        if (reference == null) {
            return null;
        }
        Object result = context.getService(reference);
        context.ungetService(reference);
        return result;
    }

    public static IStatus createStatus(int type, String message, Throwable throwable) {
        return new LoggingStatus(type, PLUGIN_ID, message, throwable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventBus eventBus() {
        EventBus result = this.eventBus;
        if (result == null) {
            Object object = lock;
            synchronized (object) {
                result = this.eventBus;
                if (result == null) {
                    this.eventBus = result = new EventBus(CORE_EVENTS_EXTENSION_POINT_ID);
                }
            }
        }
        return result;
    }

    public static IExtensionPointReaderFactory getExtensionPointReaderFactory() {
        IEclipseContext context = UtilsPlugin.getInstance().getEclipseContext();
        IExtensionPointReaderFactory factory = (IExtensionPointReaderFactory)context.get(IExtensionPointReaderFactory.class);
        return factory;
    }

    public static boolean isRunningJdk() {
        JavaCompiler systemJavaCompiler = ToolProvider.getSystemJavaCompiler();
        return systemJavaCompiler != null;
    }

    public static void fallbackLog(String message, Throwable t) {
        System.err.println(message);
        t.printStackTrace();
    }

    public void registerDebugOptionsListener(BundleContext context) {
        Hashtable<String, String> properties = new Hashtable<String, String>(2);
        ((Dictionary)properties).put("listener.symbolic.name", PLUGIN_ID);
        this.debugRegistration = context.registerService(DebugOptionsListener.class, (Object)new DebugOptionsListener(){

            public void optionsChanged(DebugOptions options) {
                UtilsPlugin.this.tracer = options.newDebugTrace(UtilsPlugin.PLUGIN_ID);
            }
        }, properties);
    }

    public void unregisterDebugOptionsListener() {
        this.debugRegistration.unregister();
        this.debugRegistration = null;
    }

    public static DebugTrace debugTracer() {
        return UtilsPlugin.getInstance().tracer;
    }

    public static boolean isDebugEnabled(String pluginId, String key) {
        return Boolean.TRUE.toString().equals(Platform.getDebugOption((String)(pluginId + key)));
    }
}

