/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils;

import com.google.common.util.concurrent.FutureCallback;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class SyncFutureCallback<T>
implements FutureCallback<T> {
    private Throwable exception;
    private T result;
    private CountDownLatch latch = new CountDownLatch(1);

    public void onFailure(Throwable exception) {
        this.exception = exception;
        this.latch.countDown();
    }

    public void onSuccess(T result) {
        this.result = result;
        this.latch.countDown();
    }

    public Optional<T> syncGetResult() throws InterruptedException {
        this.latch.await();
        return Optional.ofNullable(this.result);
    }

    public Optional<T> syncGetResult(long timeout, TimeUnit unit) throws InterruptedException {
        this.latch.await(timeout, unit);
        return Optional.ofNullable(this.result);
    }

    public Throwable getException() {
        return this.exception;
    }

    public T getResult() {
        return this.result;
    }
}

