/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils;

import java.util.concurrent.Callable;
import org.mule.tooling.utils.Producer;
import org.mule.tooling.utils.UtilsPlugin;

public class SilentRunner {
    public static final ExceptionHandler silentHandler = new SilentHandler();

    public static <T> T run(Callable<T> call, T defaultReturn, ExceptionHandler exceptionHandler) {
        try {
            return call.call();
        }
        catch (Exception e) {
            exceptionHandler.handleException(e);
            return defaultReturn;
        }
    }

    public static <T> T run(Callable<T> call, T defaultReturn) {
        try {
            return call.call();
        }
        catch (Exception e) {
            SilentRunner.handleException(e);
            return defaultReturn;
        }
    }

    public static <T> T runOrElse(Callable<T> call, Producer<T> defaultReturn) {
        try {
            return call.call();
        }
        catch (Exception e) {
            SilentRunner.handleException(e);
            return defaultReturn.call();
        }
    }

    public static void run(VoidCallable runnable) {
        try {
            runnable.call();
        }
        catch (Exception e) {
            SilentRunner.handleException(e);
        }
    }

    public static void exec(VoidCallable runnable, String operationDescription) {
        try {
            runnable.call();
        }
        catch (Exception e) {
            SilentRunner.handleException(operationDescription, e);
        }
    }

    protected static void handleException(String operationDescription, Exception e) {
        UtilsPlugin.logError("Error while doing " + operationDescription, e);
    }

    protected static void handleException(Exception e) {
        UtilsPlugin.logError("Unexpected error.", e);
    }

    public static interface ExceptionHandler {
        public void handleException(Exception var1);
    }

    public static class SilentHandler
    implements ExceptionHandler {
        @Override
        public void handleException(Exception e) {
            e.printStackTrace();
        }
    }

    @FunctionalInterface
    public static interface VoidCallable {
        public void call() throws Exception;
    }
}

