/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils;

import java.util.Locale;

public final class OsDetect {
    private static OsType detectedOS;
    private static String detectedVersion;

    public static boolean isWindows() {
        return OsDetect.getOperatingSystemType() == OsType.Windows;
    }

    public static boolean isMac() {
        return OsDetect.getOperatingSystemType() == OsType.OSX;
    }

    public static boolean isLinux() {
        return OsDetect.getOperatingSystemType() == OsType.Linux;
    }

    public static OsType getOperatingSystemType() {
        if (detectedOS == null) {
            String operatingSystem = System.getProperty("os.name", "generic").toLowerCase(Locale.ENGLISH);
            detectedOS = operatingSystem.indexOf("mac") >= 0 || operatingSystem.indexOf("darwin") >= 0 ? OsType.OSX : (operatingSystem.indexOf("win") >= 0 ? OsType.Windows : (operatingSystem.indexOf("nux") >= 0 ? OsType.Linux : OsType.Other));
        }
        return detectedOS;
    }

    public static String getOperatingSystemVersion() {
        if (detectedVersion == null) {
            detectedVersion = System.getProperty("os.version");
        }
        return detectedVersion;
    }

    public static enum OsType {
        Windows,
        OSX,
        Linux,
        Other;

    }
}

