/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.equinox.app.IApplicationContext;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.program.Program;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.mule.tooling.utils.OsDetect;
import org.osgi.framework.Bundle;

public class OSInstallationVerifier {
    private static final int MAX_RECOMMENDED_PATH = 56;
    private static final String MAX_RECOMMENDED_PATH_PROP = "studio.max.recommended.path";

    private OSInstallationVerifier() {
        throw new IllegalAccessError("Not meant to be instantiated.");
    }

    public static void verifyInstallation(IApplicationContext appContext) {
        if (OsDetect.isWindows()) {
            OSInstallationVerifier.runWindowsVerifications(appContext);
        }
    }

    private static void runWindowsVerifications(IApplicationContext appContext) {
        try {
            File brandingPlugin;
            File pluginsFolder;
            File rootDir;
            Bundle brandingBundle = appContext.getBrandingBundle();
            if (brandingBundle != null && !OSInstallationVerifier.isValidPath((rootDir = (pluginsFolder = (brandingPlugin = FileLocator.getBundleFile((Bundle)brandingBundle)).getParentFile()).getParentFile()).getCanonicalPath())) {
                OSInstallationVerifier.openDirectoryPathToLongForWindows();
            }
        }
        catch (IOException iOException) {}
    }

    public static boolean isValidPath(String rootFolder) {
        return rootFolder.length() <= OSInstallationVerifier.getMaxRecommendedPath();
    }

    private static int getMaxRecommendedPath() {
        try {
            return Integer.valueOf(System.getProperty(MAX_RECOMMENDED_PATH_PROP, String.valueOf(56)));
        }
        catch (Exception exception) {
            return 56;
        }
    }

    private static void openDirectoryPathToLongForWindows() {
        MessageDialog messageDialog = new MessageDialog(null, "Anypoint Studio 7", null, String.format("Your AnypointStudio is located in a folder that will affect its normal functioning.\n\nBecause Windows has a limit of 260 characters in the path, it is recommended that you unzip Studio in a folder closer to the root path.\n\nPlease unzip Studio in a location that has a path with less than %s characters.\n", OSInstallationVerifier.getMaxRecommendedPath()), 0, 0, new String[]{"Ok"}){

            protected Control createMessageArea(Composite composite) {
                Control createMessageArea = super.createMessageArea(composite);
                Composite messageComposite = (Composite)createMessageArea;
                Composite linkComposite = new Composite(messageComposite, 0);
                GridLayoutFactory.fillDefaults().numColumns(2).spacing(-1, -1).applyTo(linkComposite);
                Label label = new Label(linkComposite, 64);
                label.setText("For more information about installation requirements, visit our ");
                Link link = new Link(linkComposite, 64);
                link.setText("<a>documentation site.</a>");
                link.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent event) {
                        try {
                            Program.launch((String)"https://docs.mulesoft.com/studio/7.3/to-download-and-install-studio-wx");
                        }
                        catch (Exception exception) {}
                    }
                });
                GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)link);
                GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)label);
                GridDataFactory.fillDefaults().align(1, 1).span(2, 1).applyTo((Control)linkComposite);
                return createMessageArea;
            }
        };
        messageDialog.open();
        System.exit(-1);
    }
}

