/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.utils;

import com.google.common.base.Optional;
import java.util.Iterator;
import java.util.List;

public class ListHelper {
    public static <T> Optional<T> get(List<T> list, int index) {
        if (list.size() > index) {
            return Optional.of(list.get(index));
        }
        return Optional.absent();
    }

    public static <T> T reduce(Iterable<T> iterable, ReduceFunction<T> function) {
        Iterator<T> iterator = iterable.iterator();
        Object acc = iterator.hasNext() ? iterator.next() : null;
        while (iterator.hasNext()) {
            acc = function.apply(acc, iterator.next());
        }
        return acc;
    }

    public static <T> T reduce(Iterable<T> iterable, T initialValue, ReduceFunction<T> function) {
        T acc = initialValue;
        Iterator<T> iterator = iterable.iterator();
        while (iterator.hasNext()) {
            acc = function.apply(acc, iterator.next());
        }
        return acc;
    }

    public static interface ReduceFunction<T> {
        public T apply(T var1, T var2);
    }
}

